/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Measure;

public class Sheet
extends ProteinStructure {
    AlphaPolymer alphaPolymer;

    Sheet(AlphaPolymer alphaPolymer, int n, int n2, int n3, byte by) {
        super(alphaPolymer, (byte)2, n, n2, n3);
        this.alphaPolymer = alphaPolymer;
        this.subtype = by;
    }

    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.monomerCount == 2) {
            this.axisA = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new Point3f();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new Point3f();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount - 1, this.axisB);
        }
        this.axisUnitVector = new Vector3f();
        this.axisUnitVector.sub(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        Point3f point3f = new Point3f();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst, point3f);
        if (!this.lowerNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis(point3f, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        Point3f point3f2 = new Point3f();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount, point3f2);
        if (!this.upperNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis(point3f2, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        this.axisA = point3f;
        this.axisB = point3f2;
    }
}

