/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.util.Logger;

public class Token {
    public int tok;
    public Object value;
    public int intValue = Integer.MAX_VALUE;
    static final String[] astrType = new String[]{"nada", "identifier", "integer", "decimal", "string", "seqcode", "hash", "array", "point", "point4", "bitset", "matrix3f", "matrix4f", "listf", "keyword"};
    static final Token tokenSpaceBeforeSquare = new Token(1073742195, " ");
    static final Token tokenOn = new Token(0x10000D, 1, "on");
    static final Token tokenOff = new Token(0x10000C, 0, "off");
    static final Token tokenAll = new Token(0x100003, "all");
    static final Token tokenIf = new Token(135369225, "if");
    public static final Token tokenAnd = new Token(0x10100060, "and");
    public static final Token tokenAND = new Token(0x10100080, "");
    public static final Token tokenOr = new Token(0x10100050, "or");
    public static final Token tokenAndFALSE = new Token(0x10100060, "and");
    public static final Token tokenOrTRUE = new Token(0x10100050, "or");
    public static final Token tokenOpIf = new Token(806354977, "?");
    public static final Token tokenComma = new Token(0x10100030, ",");
    static final Token tokenDefineString = new Token(1060866, 4, "@");
    static final Token tokenPlus = new Token(0x101000A1, "+");
    static final Token tokenMinus = new Token(0x101000A0, "-");
    static final Token tokenTimes = new Token(0x101000B1, "*");
    static final Token tokenDivide = new Token(0x101000B0, "/");
    public static final Token tokenLeftParen = new Token(0x10100010, "(");
    public static final Token tokenRightParen = new Token(0x10100011, ")");
    static final Token tokenArraySquare = new Token(135266306, "[");
    static final Token tokenArraySelector = new Token(0x10100040, "[");
    public static final Token tokenExpressionBegin = new Token(0x100001, "expressionBegin");
    public static final Token tokenExpressionEnd = new Token(0x100002, "expressionEnd");
    public static final Token tokenConnected = new Token(135266310, "connected");
    static final Token tokenCoordinateBegin = new Token(0x10000A, "{");
    static final Token tokenRightBrace;
    static final Token tokenCoordinateEnd;
    static final Token tokenColon;
    static final Token tokenSetCmd;
    static final Token tokenSet;
    static final Token tokenSetArray;
    static final Token tokenSetProperty;
    static final Token tokenSetVar;
    static final Token tokenEquals;
    static final Token tokenScript;
    static final Token tokenSwitch;
    private static Map<String, Token> tokenMap;

    public Token() {
    }

    public Token(int n, int n2, Object object) {
        this.tok = n;
        this.intValue = n2;
        this.value = object;
    }

    public Token(int n) {
        this.tok = n;
    }

    public Token(int n, int n2) {
        this.tok = n;
        this.intValue = n2;
    }

    public Token(int n, Object object) {
        this.tok = n;
        this.value = object;
    }

    public static final Token intToken(int n) {
        return new Token(2, n);
    }

    public static boolean tokAttr(int n, int n2) {
        return (n & n2) == n2;
    }

    public static boolean tokAttrOr(int n, int n2, int n3) {
        return (n & n2) == n2 || (n & n3) == n3;
    }

    static int getPrecedence(int n) {
        return n >> 4 & 0xF;
    }

    static int getMaxMathParams(int n) {
        return n >> 9 & 7;
    }

    public static void addToken(String string, Token token) {
        tokenMap.put(string, token);
    }

    public static Token getTokenFromName(String string) {
        return tokenMap.get(string);
    }

    public static int getTokFromName(String string) {
        Token token = Token.getTokenFromName(string);
        return token == null ? 0 : token.tok;
    }

    public static String nameOf(int n) {
        for (Token token : tokenMap.values()) {
            if (token.tok != n) continue;
            return "" + token.value;
        }
        return "0x" + Integer.toHexString(n);
    }

    public String toString() {
        return "Token[" + astrType[this.tok < 14 ? this.tok : 14] + "(" + this.tok % 512 + "/0x" + Integer.toHexString(this.tok) + ")" + (this.intValue == Integer.MAX_VALUE ? "" : " intValue=" + this.intValue + "(0x" + Integer.toHexString(this.intValue) + ")") + (this.value == null ? "" : (this.value instanceof String ? " value=\"" + this.value + "\"" : " value=" + this.value)) + "]";
    }

    public static String[] getTokensLike(String string) {
        int n = string.equals("setparam") ? 0x20000000 : (string.equals("misc") ? 0x40000000 : (string.equals("mathfunc") ? 0x8100000 : 4096));
        int n2 = n == 0x20000000 ? 0x60000000 : 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Token> entry : tokenMap.entrySet()) {
            String string2 = entry.getKey();
            Token token = entry.getValue();
            if (!Token.tokAttr(token.tok, n) || n2 != 0 && Token.tokAttr(token.tok, n2)) continue;
            arrayList.add(string2);
        }
        Object[] objectArray = new String[arrayList.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = (String)arrayList.get(i);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static int getSettableTokFromString(String string) {
        int n = Token.getTokFromName(string);
        return n != 0 && Token.tokAttr(n, 2048) && !Token.tokAttr(n, 0x44100000) ? n : 0;
    }

    static {
        tokenCoordinateEnd = tokenRightBrace = new Token(0x10000E, "}");
        tokenColon = new Token(0x10100022, 58);
        tokenSetCmd = new Token(1085443, "set");
        tokenSet = new Token(1085443, 61, "");
        tokenSetArray = new Token(1085443, 91, "");
        tokenSetProperty = new Token(1085443, 46, "");
        tokenSetVar = new Token(1085443, 61, "var");
        tokenEquals = new Token(269484436, "=");
        tokenScript = new Token(135271429, "script");
        tokenSwitch = new Token(102410, "switch");
        tokenMap = new Hashtable<String, Token>();
        Object[] objectArray = new Object[]{"(", tokenLeftParen, ")", tokenRightParen, "and", tokenAnd, "&", null, "&&", null, "or", tokenOr, "|", null, "||", null, "?", tokenOpIf, ",", tokenComma, "+=", new Token(269484242), "-=", null, "*=", null, "/=", null, "\\=", null, "&=", null, "|=", null, "not", new Token(0x10100070), "!", null, "xor", new Token(0x10100051), "tog", new Token(269484114), "<", new Token(269484435), "<=", new Token(269484434), ">=", new Token(0x10100191), ">", new Token(0x10100190), "=", tokenEquals, "==", null, "!=", new Token(269484438), "<>", null, "within", new Token(135266323), ".", new Token(0x100008), "[", new Token(0x10100040), "]", new Token(0x10100041), "{", new Token(0x10000A), "}", new Token(0x10000E), "$", new Token(0x100007), "%", new Token(269484210), ":", tokenColon, ";", new Token(0x10000F), "++", new Token(269484226), "--", new Token(0x101000C1), "**", new Token(269484227), "+", tokenPlus, "-", tokenMinus, "*", tokenTimes, "/", tokenDivide, "\\", new Token(269484211), "animation", new Token(4097), "anim", null, "assign", new Token(4098), "axes", new Token(1611272194), "backbone", new Token(1115297793), "background", new Token(1610616835), "bind", new Token(4100), "bondorder", new Token(4101), "boundbox", new Token(1679429641), "boundingBox", null, "break", new Token(102407), "calculate", new Token(4102), "cartoon", new Token(1113200642), "cartoons", null, "case", new Token(102411), "catch", new Token(102412), "cd", new Token(1069064), "center", new Token(12289), "centre", null, "centerat", new Token(4105), "color", new Token(1766856708), "colour", null, "compare", new Token(135270405), "configuration", new Token(1095766022), "conformation", null, "config", null, "connect", new Token(4106), "console", new Token(528395), "continue", new Token(102408), "data", new Token(135270407), "default", new Token(102413), "define", new Token(1060866), "@", null, "delay", new Token(528396), "delete", new Token(12291), "density", new Token(1073741914), "depth", new Token(554176525), "dipole", new Token(135182), "dipoles", null, "display", new Token(1610625028), "dot", new Token(1276117505), "dots", new Token(1113198595), "draw", new Token(135184), "echo", new Token(537022465), "ellipsoid", new Token(1113198596), "ellipsoids", null, "else", new Token(364547), "elseif", new Token(102402), "end", new Token(0x119009), "endif", new Token(364548), "exit", new Token(266254), "file", new Token(1229984263), "font", new Token(4114), "for", new Token(135369224), "format", new Token(1288701960), "frame", new Token(4115), "frames", null, "frank", new Token(1611272213), "function", new Token(135368713), "functions", null, "geosurface", new Token(1113198597), "getProperty", new Token(135270410), "goto", new Token(20500), "halo", new Token(1113200646), "halos", null, "helix", new Token(137363468), "helixalpha", new Token(0x300007), "helix310", new Token(0x300008), "helixpi", new Token(0x30000A), "hbond", new Token(1612189718), "hbonds", null, "help", new Token(20482), "hide", new Token(12294), "history", new Token(1610616855), "hover", new Token(544771), "if", new Token(135369225), "in", new Token(1073741979), "initialize", new Token(266264), "invertSelected", new Token(4121), "isosurface", new Token(135197), "javascript", new Token(135287308), "label", new Token(1826248715), "labels", null, "lcaoCartoon", new Token(135198), "lcaoCartoons", null, "load", new Token(135271426), "log", new Token(36869), "loop", new Token(528410), "measure", new Token(1746538509), "measures", null, "monitor", null, "monitors", null, "meshribbon", new Token(1113200647), "meshribbons", null, "message", new Token(20485), "minimize", new Token(4126), "minimization", null, "mo", new Token(0x121021), "model", new Token(1095766028), "models", null, "move", new Token(4128), "moveTo", new Token(4130), "navigate", new Token(4131), "navigation", null, "out", new Token(0x400000FF), "parallel", new Token(102436), "pause", new Token(20487), "wait", null, "plot", new Token(4133), "plot3d", new Token(135207), "pmesh", new Token(135206), "polygon", new Token(1073742106), "polyhedra", new Token(135208), "print", new Token(36865), "process", new Token(102439), "prompt", new Token(135304707), "quaternion", new Token(0x8101011), "quaternions", null, "quit", new Token(266281), "ramachandran", new Token(1052714), "rama", null, "refresh", new Token(266283), "reset", new Token(4140), "unset", null, "restore", new Token(4141), "restrict", new Token(12295), "return", new Token(36866), "ribbon", new Token(1113200649), "ribbons", null, "rocket", new Token(1113200650), "rockets", null, "rotate", new Token(528432), "rotateSelected", new Token(4145), "save", new Token(4146), "script", tokenScript, "source", null, "select", new Token(135280132), "selectionHalos", new Token(1611141171), "selectionHalo", null, "showSelections", null, "set", tokenSetCmd, "sheet", new Token(0x300020), "show", new Token(4148), "slab", new Token(554176565), "spacefill", new Token(1113200651), "cpk", null, "spin", new Token(1611141175), "ssbond", new Token(1611141176), "ssbonds", null, "star", new Token(1113200652), "stars", null, "step", new Token(266298), "stereo", new Token(528443), "strand", new Token(1650071565), "strands", null, "structure", new Token(1641025539), "_structure", null, "strucNo", new Token(1095761939), "struts", new Token(1708089), "strut", null, "subset", new Token(0x303008), "switch", tokenSwitch, "synchronize", new Token(4156), "sync", null, "trace", new Token(1113200654), "translate", new Token(4160), "translateSelected", new Token(4162), "try", new Token(364558), "unbind", new Token(4164), "unitcell", new Token(1614417984), "var", new Token(36868), "vector", new Token(135233), "vectors", null, "vibration", new Token(4166), "while", new Token(102406), "wireframe", new Token(659523), "write", new Token(135270420), "zap", new Token(1060873), "zoom", new Token(4168), "zoomTo", new Token(4170), "atom", new Token(0x44100001), "atoms", null, "axis", new Token(1073741854), "axisangle", new Token(135266307), "basepair", new Token(1073741864), "basepairs", null, "orientation", new Token(1073742078), "orientations", null, "pdbheader", new Token(1073742088), "polymer", new Token(1095761935), "polymers", null, "residue", new Token(1073742120), "residues", null, "rotation", new Token(1073742132), "row", new Token(1276117513), "sequence", new Token(1087373320), "shape", new Token(1087373323), "state", new Token(1073742158), "symbol", new Token(1087375373), "symmetry", new Token(1089470478), "spaceGroup", new Token(1073742152), "transform", new Token(1073742176), "translation", new Token(1073742178), "url", new Token(1074790760), "abs", new Token(135266826), "absolute", new Token(0x40000002), "acos", new Token(135266819), "add", new Token(1276118017), "adpmax", new Token(1112539137), "adpmin", new Token(1112539138), "align", new Token(0x40000008), "all", tokenAll, "altloc", new Token(1087373315), "altlocs", null, "amino", new Token(0x300002), "angle", new Token(0x8100001), "array", new Token(135266306), "as", new Token(1073741848), "atomID", new Token(1095761922), "_atomID", null, "_a", null, "atomIndex", new Token(1095761923), "atomName", new Token(1087375362), "atomno", new Token(1095763969), "atomType", new Token(1087375361), "atomX", new Token(1112541185), "atomY", new Token(1112541186), "atomZ", new Token(1112541187), "average", new Token(96), "babel", new Token(0x40000020), "babel21", new Token(0x40000022), "back", new Token(0x40000024), "backlit", new Token(1073741862), "bin", new Token(1276118529), "bondCount", new Token(1095761924), "bottom", new Token(0x40000030), "branch", new Token(0x100004), "carbohydrate", new Token(3145764), "cell", new Token(1095761925), "chain", new Token(0x40D00004), "chains", null, "clear", new Token(1073741882), "clickable", new Token(3145766), "clipboard", new Token(1073741884), "connected", new Token(135266310), "constraint", new Token(0x40000046), "contourLines", new Token(0x4000004A), "coord", new Token(0x100006), "coordinates", null, "coords", null, "cos", new Token(135266821), "cross", new Token(135267329), "covalent", new Token(1112539139), "direction", new Token(1073741918), "displacement", new Token(1073741922), "displayed", new Token(3145768), "distance", new Token(1276118018), "div", new Token(1276117504), "DNA", new Token(0x300004), "dotted", new Token(0x40000066), "DSSP", new Token(1073741915), "element", new Token(1087375365), "elemno", new Token(1095763976), "_e", null, "error", new Token(0x40000070), "fill", new Token(1073741938), "find", new Token(1276118532), "fixedTemperature", new Token(1073741946), "formalCharge", new Token(1632634889), "charge", null, "eta", new Token(1112539140), "front", new Token(1073741954), "frontlit", new Token(1073741958), "frontOnly", new Token(0x40000088), "fullylit", new Token(1073741964), "fx", new Token(1112541188), "fy", new Token(1112541189), "fz", new Token(1112541190), "fxyz", new Token(1146095627), "fux", new Token(1112541191), "fuy", new Token(1112541192), "fuz", new Token(1112541193), "fuxyz", new Token(1146095628), "group", new Token(1087373318), "groups", null, "group1", new Token(1087373319), "groupID", new Token(1095761930), "_groupID", null, "_g", null, "groupIndex", new Token(1095761931), "hidden", new Token(3145770), "highlight", new Token(0x20000008), "hkl", new Token(135267841), "id", new Token(1074790550), "identify", new Token(1087373321), "ident", null, "image", new Token(1073741978), "info", new Token(1073741982), "insertion", new Token(1087373322), "insertions", null, "ionic", new Token(1112541194), "ionicRadius", null, "isAromatic", new Token(0x100009), "Jmol", new Token(1073741992), "join", new Token(1276117506), "keys", new Token(0x44100010), "last", new Token(0x400000AA), "left", new Token(1073741996), "length", new Token(1141899267), "lines", new Token(0x44100004), "list", new Token(1073742001), "mass", new Token(1112539141), "max", new Token(64), "mep", new Token(0x400000C0), "mesh", new Token(1073742018), "min", new Token(32), "mlp", new Token(1073742021), "mode", new Token(1073742022), "modify", new Token(1073742024), "modifyOrCreate", new Token(1073742026), "molecule", new Token(1095761934), "molecules", null, "modelIndex", new Token(1095761933), "monomer", new Token(0x400000D0), "mul", new Token(1276117507), "next", new Token(1073742035), "noDots", new Token(1073742042), "noFill", new Token(1073742046), "noMesh", new Token(0x400000E4), "none", new Token(0x10000B), "null", null, "inherit", null, "normal", new Token(1073742056), "noContourLines", new Token(0x400000D4), "notFrontOnly", new Token(1073742058), "noTriangles", new Token(1073742060), "now", new Token(135266318), "nucleic", new Token(0x30000E), "occupancy", new Token(1129318401), "off", tokenOff, "false", null, "on", tokenOn, "true", null, "omega", new Token(1112539142), "only", new Token(1073742072), "opaque", new Token(1073742074), "partialCharge", new Token(1112541195), "phi", new Token(1112539143), "plane", new Token(135266319), "play", new Token(0x40000110), "playRev", new Token(1073742098), "point", new Token(0x8100010), "points", null, "pointGroup", new Token(1073742102), "polymerLength", new Token(1095761936), "previous", new Token(1073742108), "prev", null, "property", new Token(1716520972), "properties", null, "protein", new Token(0x300010), "psi", new Token(1112539144), "purine", new Token(3145746), "pyrimidine", new Token(3145748), "random", new Token(135267332), "range", new Token(1073742114), "rasmol", new Token(1073742116), "replace", new Token(1276118019), "resno", new Token(1095761937), "resume", new Token(266286), "rewind", new Token(1073742126), "reverse", new Token(1141899269), "right", new Token(1073742128), "RNA", new Token(3145750), "rubberband", new Token(1073742134), "saSurface", new Token(1073742136), "scale", new Token(1073742138), "search", new Token(135267335), "smarts", null, "selected", new Token(1114638349), "shapely", new Token(0x40000140), "sidechain", new Token(3145754), "sin", new Token(135266820), "site", new Token(1095761938), "size", new Token(1141899270), "smiles", new Token(135267336), "substructure", new Token(1238369286), "solid", new Token(1073742151), "sort", new Token(1276117010), "specialPosition", new Token(3145772), "sqrt", new Token(135266822), "split", new Token(1276117508), "stddev", new Token(192), "straightness", new Token(1112539145), "structureId", new Token(1087373324), "supercell", new Token(1073742163), "sub", new Token(1276117509), "sum", new Token(128), "sum2", new Token(160), "surface", new Token(3145756), "surfaceDistance", new Token(1112539146), "symop", new Token(1297090050), "temperature", new Token(1112541198), "relativeTemperature", null, "theta", new Token(1112539147), "thisModel", new Token(3145758), "ticks", new Token(1073742164), "top", new Token(1074790748), "torsion", new Token(1073742174), "trajectory", new Token(0x2000000E), "trajectories", null, "translucent", new Token(1073742180), "triangles", new Token(1073742182), "trim", new Token(1276117510), "type", new Token(1141899272), "ux", new Token(1112539148), "uy", new Token(1112539149), "uz", new Token(1112539150), "uxyz", new Token(1146093581), "user", new Token(1073742186), "valence", new Token(1095763988), "vanderWaals", new Token(1112541199), "vdw", null, "vdwRadius", null, "visible", new Token(3145774), "volume", new Token(1313866247), "vx", new Token(1112541200), "vy", new Token(1112541201), "vz", new Token(1112541202), "vxyz", new Token(1146095630), "xyz", new Token(1146095626), "w", new Token(1141899279), "x", new Token(1112541203), "y", new Token(1112541204), "z", new Token(1112541205), "addHydrogens", new Token(0x40000004), "allConnected", new Token(0x4000000A), "angstroms", new Token(0x4000000C), "anisotropy", new Token(0x4000000E), "arc", new Token(0x40100010), "area", new Token(1073741842), "aromatic", new Token(1076887572), "arrow", new Token(1073741846), "auto", new Token(1073741852), "barb", new Token(1073741861), "binary", new Token(1073741866), "blockData", new Token(1073741868), "cancel", new Token(1073741873), "cap", new Token(1074790450), "cavity", new Token(0x40000034), "check", new Token(1073741878), "circle", new Token(1073741880), "collapsed", new Token(1073741886), "col", new Token(1276117512), "colorScheme", new Token(0x40000040), "command", new Token(0x40000042), "commands", new Token(0x40000044), "contour", new Token(0x40000048), "contours", new Token(0x4000004C), "corners", new Token(0x4000004E), "criterion", new Token(1073741905), "create", new Token(0x40000050), "crossed", new Token(1073741906), "curve", new Token(0x40000054), "cutoff", new Token(1073741910), "cylinder", new Token(1073741912), "diameter", new Token(1073741916), "discrete", new Token(0x40000060), "distanceFactor", new Token(0x40000064), "downsample", new Token(1073741928), "eccentricity", new Token(1073741930), "ed", new Token(1074790508), "edges", new Token(1073741934), "energy", new Token(1073741935), "exitJmol", new Token(266257), "faceCenterOffset", new Token(1073741937), "filter", new Token(0x40000074), "first", new Token(1073741942), "fixed", new Token(1060869), "fix", null, "flat", new Token(1073741948), "fps", new Token(1074790526), "from", new Token(0x40000080), "frontEdges", new Token(0x40000084), "full", new Token(1073741961), "fullPlane", new Token(1073741962), "functionXY", new Token(1073741966), "functionXYZ", new Token(0x40000090), "gridPoints", new Token(1073741970), "homo", new Token(1073741973), "ignore", new Token(1073741976), "increment", new Token(1073741980), "insideout", new Token(0x400000A0), "interior", new Token(1073741986), "intersection", new Token(135267842), "internal", new Token(0x400000A4), "lattice", new Token(1073741995), "line", new Token(1073741998), "lineData", new Token(0x400000B0), "lobe", new Token(1073742002), "lonePair", new Token(0x400000B4), "lp", new Token(1073742006), "lumo", new Token(1073742008), "manifest", new Token(1073742010), "mapProperty", new Token(0x10101C), "map", null, "maxSet", new Token(1073742014), "minSet", new Token(0x400000C4), "modelBased", new Token(0x400000CC), "molecular", new Token(1073742030), "mrc", new Token(1073742033), "msms", new Token(1073742034), "noCross", new Token(1073742038), "noDebug", new Token(1073742040), "noEdges", new Token(1073742044), "noHead", new Token(0x400000E0), "noLoad", new Token(1073742050), "noPlane", new Token(1073742054), "object", new Token(0x400000F0), "obj", new Token(0x400000EE), "offset", new Token(1073742066), "offsetSide", new Token(0x400000F4), "once", new Token(1073742070), "orbital", new Token(1073742076), "atomicOrbital", new Token(1073741850), "packed", new Token(0x40000100), "palindrome", new Token(1073742082), "path", new Token(0x40000104), "pdb", new Token(1074790662), "period", new Token(1073742090), "periodic", null, "perpendicular", new Token(1073742092), "perp", null, "phase", new Token(1073742094), "pocket", new Token(0x40000114), "pointsPerAngstrom", new Token(1073742104), "radical", new Token(1073742112), "rad", new Token(1073742110), "reference", new Token(1073742118), "resolution", new Token(1073742122), "reverseColor", new Token(1073742124), "rotate45", new Token(1073742130), "selection", new Token(1073742140), "sigma", new Token(1073742146), "sign", new Token(1073742147), "silent", new Token(0x40000144), "sphere", new Token(1073742154), "squared", new Token(1073742156), "steps", new Token(1073742160), "stop", new Token(1073742162), "title", new Token(1073742166), "titleFormat", new Token(1073742168), "to", new Token(1074790746), "value", new Token(1073742188), "variable", new Token(1073742190), "variables", new Token(1073742192), "vertices", new Token(1073742194), "width", new Token(1073742196), "backgroundModel", new Token(0x20000002), "debug", new Token(0x20000004), "defaultLattice", new Token(0x20000006), "measurements", new Token(537006111), "measurement", null, "scale3D", new Token(0x60000004), "toggleLabel", new Token(0x60000005), "userColorScheme", new Token(0x20000010), "timeout", new Token(536875070), "timeouts", null, "appletProxy", new Token(0x20800002), "atomTypes", new Token(545259524), "axesColor", new Token(545259526), "axis1Color", new Token(0x20800008), "axis2Color", new Token(545259530), "axis3Color", new Token(545259532), "backgroundColor", new Token(545259534), "bondmode", new Token(0x60000001), "boundBoxColor", new Token(545259536), "boundingBoxColor", null, "currentLocalPath", new Token(545259538), "dataSeparator", new Token(545259540), "defaultAngleLabel", new Token(545259542), "defaultColorScheme", new Token(545259544), "defaultColors", null, "defaultDirectory", new Token(545259546), "defaultDistanceLabel", new Token(545259548), "defaultLoadFilter", new Token(545259549), "defaultLoadScript", new Token(545259550), "defaults", new Token(0x20800020), "defaultTorsionLabel", new Token(0x20800022), "defaultVDW", new Token(545259556), "edsUrlCutoff", new Token(545259557), "edsUrlFormat", new Token(545259558), "fileCacheDirectory", new Token(545259559), "fontsize", new Token(0x60000002), "helpPath", new Token(0x20800028), "hoverLabel", new Token(545259562), "language", new Token(545259564), "loadFormat", new Token(545259566), "logFile", new Token(545259567), "measurementUnits", new Token(545259568), "picking", new Token(545259569), "pickingStyle", new Token(545259570), "pickLabel", new Token(545259572), "propertyColorScheme", new Token(545259574), "quaternionFrame", new Token(545259578), "smilesUrlFormat", new Token(545259580), "unitCellColor", new Token(545259582), "axesScale", new Token(0x22000002), "axisScale", null, "bondTolerance", new Token(0x22000004), "cameraDepth", new Token(0x22000006), "defaultDrawArrowScale", new Token(0x22000008), "defaultTranslucent", new Token(0x2200000A), "dipoleScale", new Token(0x2200000C), "ellipsoidAxisDiameter", new Token(0x2200000E), "gestureSwipeFactor", new Token(0x2200000F), "hbondsAngleMinimum", new Token(0x22000010), "hbondsDistanceMaximum", new Token(0x22000011), "hoverDelay", new Token(0x22000012), "loadAtomDataTolerance", new Token(570425363), "minBondDistance", new Token(570425364), "minimizationCriterion", new Token(570425365), "mouseDragFactor", new Token(570425366), "mouseWheelFactor", new Token(570425367), "navFPS", new Token(570425370), "navigationDepth", new Token(570425371), "navigationSlab", new Token(570425372), "navigationSpeed", new Token(570425374), "navX", new Token(0x22000020), "navY", new Token(0x22000022), "navZ", new Token(0x22000024), "pointGroupDistanceTolerance", new Token(0x22000026), "pointGroupLinearTolerance", new Token(0x22000028), "radius", new Token(1666189314), "rotationRadius", new Token(0x2200002C), "scaleAngstromsPerInch", new Token(0x2200002E), "sheetSmoothing", new Token(0x22000030), "slabRange", new Token(570425393), "solventProbeRadius", new Token(0x22000032), "spinFPS", new Token(570425396), "spinX", new Token(570425398), "spinY", new Token(570425400), "spinZ", new Token(570425402), "stereoDegrees", new Token(570425404), "strutDefaultRadius", new Token(570425406), "strutLengthMaximum", new Token(0x22000040), "vectorScale", new Token(0x22000042), "vibrationPeriod", new Token(0x22000044), "vibrationScale", new Token(570425414), "visualRange", new Token(570425416), "ambientPercent", new Token(0x21000002), "ambient", null, "animationFps", new Token(553648132), "axesMode", new Token(553648134), "bondRadiusMilliAngstroms", new Token(553648136), "delayMaximumMs", new Token(553648138), "diffusePercent", new Token(553648142), "diffuse", null, "dotDensity", new Token(553648143), "dotScale", new Token(0x21000010), "ellipsoidDotCount", new Token(0x21000011), "helixStep", new Token(0x21000012), "hermiteLevel", new Token(553648147), "historyLevel", new Token(553648148), "logLevel", new Token(553648150), "minimizationSteps", new Token(553648151), "percentVdwAtom", new Token(553648152), "perspectiveModel", new Token(553648154), "phongExponent", new Token(553648156), "pickingSpinRate", new Token(553648158), "propertyAtomNumberField", new Token(553648159), "propertyAtomNumberColumnCount", new Token(0x21000020), "propertyDataColumnCount", new Token(0x21000022), "propertyDataField", new Token(553648164), "repaintWaitMs", new Token(553648165), "ribbonAspectRatio", new Token(553648166), "scriptReportingLevel", new Token(553648168), "showScript", new Token(0x2000000A), "smallMoleculeMaxAtoms", new Token(553648170), "specular", new Token(0x2000000C), "specularExponent", new Token(553648172), "specularPercent", new Token(553648174), "specPercent", null, "specularPower", new Token(553648176), "specpower", null, "strandCount", new Token(553648178), "strandCountForMeshRibbon", new Token(553648180), "strandCountForStrands", new Token(553648182), "strutSpacing", new Token(553648184), "zDepth", new Token(553648186), "zSlab", new Token(553648188), "zshadePower", new Token(553648190), "allowEmbeddedScripts", new Token(0x24000002), "allowGestures", new Token(0x24000004), "allowKeyStrokes", new Token(603979781), "allowModelKit", new Token(603979782), "allowMoveAtoms", new Token(603979783), "allowMultiTouch", new Token(603979784), "allowRotateSelected", new Token(603979785), "antialiasDisplay", new Token(603979786), "antialiasImages", new Token(603979788), "antialiasTranslucent", new Token(603979790), "appendNew", new Token(603979792), "applySymmetryToBonds", new Token(603979794), "atomPicking", new Token(603979796), "autobond", new Token(603979798), "autoFPS", new Token(603979800), "axesMolecular", new Token(603979804), "axesOrientationRasmol", new Token(603979806), "axesUnitCell", new Token(0x24000020), "axesWindow", new Token(0x24000022), "bondModeOr", new Token(0x24000024), "bondPicking", new Token(603979814), "bonds", new Token(1678770178), "bond", null, "cartoonBaseEdges", new Token(603979818), "cartoonRockets", new Token(603979819), "chainCaseSensitive", new Token(603979820), "colorRasmol", new Token(603979822), "debugScript", new Token(603979824), "defaultStructureDssp", new Token(603979825), "disablePopupMenu", new Token(603979826), "displayCellParameters", new Token(603979828), "dotsSelectedOnly", new Token(603979829), "dotSurface", new Token(603979830), "dragSelected", new Token(603979831), "drawHover", new Token(603979832), "drawPicking", new Token(603979833), "dsspCalculateHydrogenAlways", new Token(603979834), "dynamicMeasurements", new Token(603979835), "ellipsoidArcs", new Token(603979836), "ellipsoidAxes", new Token(603979837), "ellipsoidBall", new Token(603979838), "ellipsoidDots", new Token(603979839), "ellipsoidFill", new Token(0x24000040), "fileCaching", new Token(0x24000042), "fontCaching", new Token(0x24000044), "fontScaling", new Token(603979845), "forceAutoBond", new Token(603979846), "fractionalRelative", new Token(603979848), "greyscaleRendering", new Token(603979850), "hbondsBackbone", new Token(603979852), "hbondsRasmol", new Token(603979853), "hbondsSolid", new Token(603979854), "hetero", new Token(0x60300006), "hideNameInPopup", new Token(603979858), "hideNavigationPoint", new Token(603979860), "hideNotSelected", new Token(603979862), "highResolution", new Token(603979864), "hydrogen", new Token(1613758476), "hydrogens", null, "imageState", new Token(603979868), "isKiosk", new Token(603979869), "isosurfacePropertySmoothing", new Token(603979870), "isosurfacePropertySmoothingPower", new Token(553648149), "justifyMeasurements", new Token(603979872), "languageTranslation", new Token(603979873), "legacyAutoBonding", new Token(603979874), "logCommands", new Token(603979875), "logGestures", new Token(603979876), "measureAllModels", new Token(603979877), "measurementLabels", new Token(603979878), "measurementNumbers", new Token(0x60000003), "messageStyleChime", new Token(603979879), "minimizationRefresh", new Token(603979880), "minimizationSilent", new Token(603979881), "modelkitMode", new Token(603979882), "monitorEnergy", new Token(603979883), "multipleBondRadiusFactor", new Token(570425368), "multipleBondSpacing", new Token(570425369), "multiProcessor", new Token(603979884), "navigateSurface", new Token(603979885), "navigationMode", new Token(603979886), "navigationPeriodic", new Token(603979887), "pdbGetHeader", new Token(603979888), "pdbSequential", new Token(603979890), "perspectiveDepth", new Token(603979892), "preserveState", new Token(603979893), "rangeSelected", new Token(603979894), "refreshing", new Token(603979896), "ribbonBorder", new Token(603979898), "rocketBarrels", new Token(603979900), "saveProteinStructureState", new Token(603979902), "scriptQueue", new Token(603979904), "selectAllModels", new Token(603979906), "selectHetero", new Token(603979908), "selectHydrogen", new Token(603979910), "showAxes", new Token(603979914), "showBoundBox", new Token(603979916), "showBoundingBox", null, "showFrank", new Token(603979918), "showHiddenSelectionHalos", new Token(603979920), "showHydrogens", new Token(603979922), "showKeyStrokes", new Token(603979924), "showMeasurements", new Token(603979926), "showMultipleBonds", new Token(603979928), "showNavigationPointAlways", new Token(603979930), "showUnitcell", new Token(603979936), "slabByAtom", new Token(603979938), "slabByMolecule", new Token(603979940), "slabEnabled", new Token(603979942), "smartAromatic", new Token(603979944), "solvent", new Token(1613758488), "solventProbe", new Token(603979948), "ssBondsBackbone", new Token(603979952), "statusReporting", new Token(603979954), "strutsMultiple", new Token(603979955), "syncMouse", new Token(603979956), "syncScript", new Token(603979958), "testFlag1", new Token(603979960), "testFlag2", new Token(603979962), "testFlag3", new Token(603979964), "testFlag4", new Token(603979966), "traceAlpha", new Token(603979967), "undo", new Token(603979968), "useArcBall", new Token(603979969), "useMinimizationThread", new Token(603979970), "useNumberLocalization", new Token(603979972), "waitForMoveTo", new Token(603979973), "windowCentered", new Token(603979974), "wireframeRotation", new Token(603979976), "zeroBasedXyzRasmol", new Token(603979978), "zoomEnabled", new Token(603979980), "zoomLarge", new Token(603979982), "zShade", new Token(603979984)};
        Token token = null;
        int n = 0;
        while (n + 1 < objectArray.length) {
            String string = (String)objectArray[n];
            String string2 = string.toLowerCase();
            Token token2 = (Token)objectArray[n + 1];
            if (token2 == null) {
                token2 = token;
            }
            if (token2.value == null) {
                token2.value = string;
            }
            if (tokenMap.get(string2) != null) {
                Logger.error("duplicate token definition:" + string2);
            }
            tokenMap.put(string2, token2);
            token = token2;
            n += 2;
        }
        Logger.info(objectArray.length + " script command tokens");
    }
}

