/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.viewer.JmolConstants;

public class Balls
extends AtomShape {
    protected void setSize(RadiusData radiusData, BitSet bitSet) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        int n = Math.min(this.atoms.length, bitSet.length());
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0 && n2 < n) {
            Atom atom = this.atoms[n2];
            atom.setMadAtom(this.viewer, radiusData);
            this.bsSizeSet.set(n2);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("color" == string) {
            short s = Graphics3D.getColix(object);
            if (s == 0) {
                s = 2;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            byte by = JmolConstants.pidOf(object);
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                Atom atom = this.atoms[n];
                atom.setColixAtom(this.setColix(s, by, atom));
                this.bsColixSet.set(n, s != 2 || by != 0);
                atom.setPaletteID(by);
                n = bitSet.nextSetBit(n + 1);
            }
            return;
        }
        if ("colorValues" == string) {
            int[] nArray = (int[])object;
            if (nArray.length == 0) {
                return;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = 0;
            Integer n2 = null;
            int n3 = bitSet.nextSetBit(0);
            while (n3 >= 0) {
                short s;
                if (n >= nArray.length) {
                    return;
                }
                if ((s = Graphics3D.getColix(n2 = Integer.valueOf(nArray[n++]))) == 0) {
                    s = 2;
                }
                byte by = JmolConstants.pidOf(n2);
                Atom atom = this.atoms[n3];
                atom.setColixAtom(this.setColix(s, by, atom));
                this.bsColixSet.set(n3, s != 2 || by != 0);
                atom.setPaletteID(by);
                n3 = bitSet.nextSetBit(n3 + 1);
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl = ((String)object).equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                this.atoms[n].setTranslucent(bl, this.translucentLevel);
                if (bl) {
                    this.bsColixSet.set(n);
                }
                n = bitSet.nextSetBit(n + 1);
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public void setModelClickability() {
        BitSet bitSet = this.viewer.getDeletedAtoms();
        if (bitSet == null) {
            bitSet = new BitSet();
        }
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            atom.setClickable(0);
            if (bitSet.get(n) || (atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public void setVisibilityFlags(BitSet bitSet) {
        boolean bl = this.viewer.getShowHydrogens();
        BitSet bitSet2 = this.viewer.getDeletedAtoms();
        int n = this.atomCount;
        while (--n >= 0) {
            int n2;
            Atom atom = this.atoms[n];
            int n3 = atom.getShapeVisibilityFlags();
            atom.setShapeVisibilityFlags(n3 &= 0xFFFFFFFE & ~this.myVisibilityFlag);
            if (bitSet2 != null && bitSet2.get(n) || !bl && atom.getElementNumber() == 1 || !bitSet.get(n2 = atom.getModelIndex())) continue;
            atom.setShapeVisibility(1, true);
            if (atom.madAtom == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setShapeVisibility(this.myVisibilityFlag, true);
        }
    }

    public String getShapeState() {
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        float f = 0.0f;
        for (int i = 0; i < this.atomCount; ++i) {
            byte by;
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                float f2;
                f = this.atoms[i].madAtom;
                if (f2 < 0.0f) {
                    Balls.setStateInfo(hashtable, i, "Spacefill on");
                } else {
                    Balls.setStateInfo(hashtable, i, "Spacefill " + f / 2000.0f);
                }
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i) || (by = this.atoms[i].getPaletteID()) == 1 && !this.atoms[i].isTranslucent()) continue;
            Balls.setStateInfo(hashtable, i, this.getColorCommand("atoms", by, this.atoms[i].getColix()));
        }
        return Balls.getShapeCommands(hashtable, null);
    }
}

