/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.util.Logger;

public class Elements {
    public static final String[] elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
    public static final float[] atomicMass = new float[]{0.0f, 1.008f, 4.003f, 6.941f, 9.012f, 10.81f, 12.011f, 14.007f, 15.999f, 18.998f, 20.18f, 22.99f, 24.305f, 26.981f, 28.086f, 30.974f, 32.07f, 35.453f, 39.948f, 39.1f, 40.08f, 44.956f, 47.88f, 50.941f, 52.0f, 54.938f, 55.847f, 58.93f, 58.69f, 63.55f, 65.39f, 69.72f, 72.61f, 74.92f, 78.96f, 79.9f, 83.8f, 85.47f, 87.62f, 88.91f, 91.22f, 92.91f, 95.94f, 98.91f, 101.07f, 102.91f, 106.42f, 107.87f, 112.41f, 114.82f, 118.71f, 121.75f, 127.6f, 126.91f, 131.29f, 132.91f, 137.33f, 138.91f, 140.12f, 140.91f, 144.24f, 144.9f, 150.36f, 151.96f, 157.25f, 158.93f, 162.5f, 164.93f, 167.26f, 168.93f, 173.04f, 174.97f, 178.49f, 180.95f, 183.85f, 186.21f, 190.2f, 192.22f, 195.08f, 196.97f, 200.59f, 204.38f, 207.2f, 208.98f, 210.0f, 210.0f, 222.0f, 223.0f, 226.03f, 227.03f, 232.04f, 231.04f, 238.03f, 237.05f, 239.1f, 243.1f, 247.1f, 247.1f, 252.1f, 252.1f, 257.1f, 256.1f, 259.1f, 260.1f, 261.0f, 262.0f, 263.0f, 262.0f, 265.0f, 268.0f};
    public static final int elementNumberMax = elementSymbols.length;
    public static Map<String, Integer> htElementMap;
    public static final String[] elementNames;
    private static int[] naturalIsotopeMasses;
    private static final short[] altElementNumbers;
    public static final int altElementMax;
    private static final String[] altElementSymbols;
    private static final String[] altElementNames;

    public static float getAtomicMass(int n) {
        return n < 1 || n >= atomicMass.length ? 0.0f : atomicMass[n];
    }

    public static final short elementNumberFromSymbol(String string, boolean bl) {
        Serializable serializable;
        if (htElementMap == null) {
            Integer n;
            String string2;
            serializable = new Hashtable();
            int n2 = elementNumberMax;
            while (--n2 >= 0) {
                string2 = elementSymbols[n2];
                n = n2;
                serializable.put(string2, n);
                if (string2.length() != 2) continue;
                serializable.put(string2.toUpperCase(), n);
            }
            n2 = altElementMax;
            while (--n2 >= 4) {
                string2 = altElementSymbols[n2];
                n = altElementNumbers[n2];
                serializable.put(string2, n);
                if (string2.length() != 2) continue;
                serializable.put(string2.toUpperCase(), n);
            }
            htElementMap = serializable;
        }
        if (string == null) {
            return 0;
        }
        serializable = htElementMap.get(string);
        if (serializable != null) {
            return (short)((Integer)serializable).intValue();
        }
        if (!bl) {
            Logger.error("'" + string + "' is not a recognized symbol");
        }
        return 0;
    }

    public static final String elementSymbolFromNumber(int n) {
        if (n >= elementNumberMax) {
            int n2 = altElementMax;
            while (--n2 >= 0) {
                if (n != altElementNumbers[n2]) continue;
                return altElementSymbols[n2];
            }
            n %= 128;
        }
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementSymbols[n];
    }

    public static final String elementNameFromNumber(int n) {
        if (n >= elementNumberMax) {
            int n2 = altElementMax;
            while (--n2 >= 0) {
                if (n != altElementNumbers[n2]) continue;
                return altElementNames[n2];
            }
            n %= 128;
        }
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementNames[n];
    }

    public static final String altElementNameFromIndex(int n) {
        return altElementNames[n];
    }

    public static final short altElementNumberFromIndex(int n) {
        return altElementNumbers[n];
    }

    public static final String altElementSymbolFromIndex(int n) {
        return altElementSymbols[n];
    }

    public static final String altIsotopeSymbolFromIndex(int n) {
        short s = altElementNumbers[n];
        return (s >> 7) + Elements.elementSymbolFromNumber(s & 0x7F);
    }

    public static final int altElementIndexFromNumber(int n) {
        for (int i = 0; i < altElementMax; ++i) {
            if (altElementNumbers[i] != n) continue;
            return i;
        }
        return 0;
    }

    public static int getNaturalIsotope(int n) {
        for (int i = 0; i < naturalIsotopeMasses.length; i += 2) {
            if (naturalIsotopeMasses[i] != n) continue;
            return naturalIsotopeMasses[++i];
        }
        return 0;
    }

    static {
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        naturalIsotopeMasses = new int[]{1, 1, 6, 12, 7, 14, 8, 16};
        altElementNumbers = new short[]{0, 13, 16, 55, 257, 385, 1414, 1670, 1798, 1927};
        altElementMax = altElementNumbers.length;
        altElementSymbols = new String[]{"Xx", "Al", "S", "Cs", "D", "T", "11C", "13C", "14C", "15N"};
        altElementNames = new String[]{"dummy", "aluminium", "sulphur", "caesium", "deuterium", "tritium", "", "", "", ""};
    }
}

