/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.script.Token;
import org.jmol.shape.Shape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeManager {
    private Viewer viewer;
    private Graphics3D g3d;
    private Shape[] shapes;
    private ModelSet modelSet;
    private final BitSet bsOK = new BitSet();

    public ShapeManager(Viewer viewer) {
        this.viewer = viewer;
        this.g3d = viewer.getGraphics3D();
    }

    public ShapeManager(Viewer viewer, ModelSet modelSet) {
        this(viewer);
        this.resetShapes();
        this.loadDefaultShapes(modelSet);
    }

    public Shape[] getShapes() {
        return this.shapes;
    }

    public void resetShapes() {
        if (!this.viewer.isDataOnly()) {
            this.shapes = new Shape[34];
        }
    }

    private Shape allocateShape(int n) {
        if (n == 2 || n == 3 || n == 4) {
            return null;
        }
        String string = JmolConstants.getShapeClassName(n);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            this.viewer.setShapeErrorState(n, "allocate");
            shape.initializeShape(this.viewer, this.g3d, this.modelSet, n);
            this.viewer.setShapeErrorState(-1, null);
            return shape;
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate shape:" + string, exception);
            return null;
        }
    }

    public Shape getShape(int n) {
        return this.shapes == null ? null : this.shapes[n];
    }

    public void setShapeSize(int n, int n2, RadiusData radiusData, BitSet bitSet) {
        if (this.shapes == null) {
            return;
        }
        if (bitSet == null && (n != 1 || n2 != Integer.MAX_VALUE)) {
            bitSet = this.viewer.getSelectionSet(false);
        }
        if (radiusData != null && radiusData.value != 0.0f && radiusData.vdwType == 1112541198) {
            this.modelSet.getBfactor100Lo();
        }
        this.viewer.setShapeErrorState(n, "set size");
        if (radiusData != null && radiusData.value != 0.0f || radiusData == null && n2 != 0) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setShapeSize(n2, radiusData, bitSet);
        }
        this.viewer.setShapeErrorState(-1, null);
    }

    public Shape loadShape(int n) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[n] == null) {
            this.shapes[n] = this.allocateShape(n);
        }
        return this.shapes[n];
    }

    public void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.shapes == null || this.shapes[n] == null) {
            return;
        }
        this.viewer.setShapeErrorState(n, "set " + string);
        this.shapes[n].setShapeProperty(string.intern(), object, bitSet);
        this.viewer.setShapeErrorState(-1, null);
    }

    public void releaseShape(int n) {
        if (this.shapes != null) {
            this.shapes[n] = null;
        }
    }

    public Object getShapeProperty(int n, String string, int n2) {
        if (this.shapes == null || this.shapes[n] == null) {
            return null;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        Object object = this.shapes[n].getProperty(string, n2);
        this.viewer.setShapeErrorState(-1, null);
        return object;
    }

    public boolean getShapeProperty(int n, String string, Object[] objectArray) {
        if (this.shapes == null || this.shapes[n] == null) {
            return false;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        boolean bl = this.shapes[n].getProperty(string, objectArray);
        this.viewer.setShapeErrorState(-1, null);
        return bl;
    }

    public int getShapeIdFromObjectName(String string) {
        if (this.shapes != null) {
            for (int i = 16; i < 28; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void setModelVisibility() {
        int n;
        if (this.shapes == null || this.shapes[0] == null) {
            return;
        }
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 34; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bitSet);
        }
        this.shapes[0].setVisibilityFlags(bitSet);
        for (n = 0; n < 34; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    float getAtomShapeValue(int n, Group group, int n2) {
        int n3 = JmolConstants.shapeTokenIndex(n);
        if (n3 < 0 || this.shapes[n3] == null) {
            return 0.0f;
        }
        int n4 = this.shapes[n3].getSize(n2);
        if (n4 == 0) {
            if ((group.shapeVisibilityFlags & this.shapes[n3].myVisibilityFlag) == 0) {
                return 0.0f;
            }
            n4 = this.shapes[n3].getSize(group);
        }
        return (float)n4 / 2000.0f;
    }

    public boolean frankClicked(int n, int n2) {
        Shape shape = this.shapes[33];
        return shape != null && shape.wasClicked(n, n2);
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet, boolean bl) {
        Shape shape = this.shapes[1];
        if (bl && shape != null && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[28];
        if (shape != null && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[23];
        if (shape != null && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[22];
        if (shape != null && this.viewer.getDrawHover() && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[33];
        return this.viewer.getShowFrank() && shape != null && shape.checkObjectHovered(n, n2, bitSet);
    }

    public Token checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Point3fi point3fi = null;
        Shape shape = this.shapes[23];
        if (shape != null && (this.viewer.getDrawPicking() || this.viewer.getNavigationMode() && this.viewer.getNavigateSurface()) && (point3fi = shape.checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(135197, point3fi);
        }
        if (n3 != 0 && this.viewer.getBondPicking() && (point3fi = this.shapes[1].checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(1678770178, point3fi);
        }
        shape = this.shapes[28];
        if (shape != null && n3 != 0 && (point3fi = shape.checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(537022465, point3fi);
        }
        shape = this.shapes[22];
        if (shape != null && (point3fi = shape.checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(135184, point3fi);
        }
        return null;
    }

    public boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BitSet bitSet, int n6) {
        for (int i = n6; i < 34; ++i) {
            Shape shape = this.shapes[i];
            if ((shape == null || !shape.checkObjectDragged(n, n2, n3, n4, n5, bitSet)) && n6 <= 0) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.shapes != null) {
            for (int i = 0; i < 34; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null) continue;
                String string = JmolConstants.shapeClassBases[i];
                List<Map<String, Object>> list = shape.getShapeDetail();
                if (list == null) continue;
                hashtable.put(string, list);
            }
        }
        if (stringBuffer.length() > 0) {
            hashtable.put("shapeCommands", stringBuffer.toString());
        }
        return hashtable;
    }

    public void loadDefaultShapes(ModelSet modelSet) {
        this.setShapeModelSet(modelSet);
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(6);
        this.loadShape(30);
        this.loadShape(31);
    }

    public void refreshShapeTrajectories(int n, BitSet bitSet) {
        Integer n2 = n;
        for (int i = 0; i < 34; ++i) {
            if (this.shapes[i] == null) continue;
            this.setShapeProperty(i, "refreshTrajectories", n2, bitSet);
        }
    }

    public void deleteShapeAtoms(Object[] objectArray, BitSet bitSet) {
        if (this.shapes != null) {
            for (int i = 0; i < 34; ++i) {
                if (this.shapes[i] == null) continue;
                this.setShapeProperty(i, "deleteModelAtoms", objectArray, bitSet);
            }
        }
    }

    public void setLabel(String string, BitSet bitSet) {
        if (string != null) {
            this.loadShape(5);
            this.setShapeSize(5, 0, null, bitSet);
        }
        this.setShapeProperty(5, "label", string, bitSet);
    }

    public void setAtomLabel(String string, int n) {
        if (this.shapes == null) {
            return;
        }
        this.loadShape(5);
        this.shapes[5].setProperty("label:" + string, n, null);
    }

    public void findNearestShapeAtomIndex(int n, int n2, Atom[] atomArray, BitSet bitSet) {
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length && atomArray[0] == null; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].findNearestAtomIndex(n, n2, atomArray, bitSet);
            }
        }
    }

    public void getShapeState(StringBuffer stringBuffer, boolean bl) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < 34; ++i) {
            String string;
            Shape shape = this.shapes[i];
            if (shape == null || !bl && !JmolConstants.isShapeSecondary(i) || (string = shape.getShapeState()) == null || string.length() <= 1) continue;
            stringBuffer.append(string);
        }
        stringBuffer.append("  select *;\n");
    }

    public void resetBioshapes(BitSet bitSet) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
            this.shapes[i].setModelSet(this.modelSet);
            this.shapes[i].setShapeSize(0, null, bitSet);
            this.shapes[i].setShapeProperty("color", new Byte(0), bitSet);
        }
    }

    private void setShapeModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null) continue;
            this.shapes[i].setModelSet(modelSet);
        }
    }

    public void mergeShapes(Shape[] shapeArray) {
        if (shapeArray == null) {
            return;
        }
        if (this.shapes == null) {
            this.shapes = shapeArray;
        } else {
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeArray[i] == null) continue;
                if (this.shapes[i] == null) {
                    this.loadShape(i);
                }
                this.shapes[i].merge(shapeArray[i]);
            }
        }
    }

    public BitSet transformAtoms(boolean bl) {
        if (!bl) {
            return this.bsOK;
        }
        this.bsOK.clear();
        Atom[] atomArray = this.modelSet.atoms;
        Vector3f[] vector3fArray = this.modelSet.vibrationVectors;
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Atom atom = atomArray[n];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            this.bsOK.set(n);
            Point3i point3i = vector3fArray != null && atom.hasVibration() ? this.viewer.transformPoint((Point3f)atom, vector3fArray[n]) : this.viewer.transformPoint(atom);
            atom.screenX = point3i.x;
            atom.screenY = point3i.y;
            atom.screenZ = point3i.z;
            atom.screenDiameter = this.viewer.scaleToScreen(point3i.z, Math.abs(atom.madAtom));
        }
        return this.bsOK;
    }
}

