/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.applet.Applet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jmol.api.Interface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolDialogInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.script.ScriptContext;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusManager {
    protected Viewer viewer;
    private JmolStatusListener jmolStatusListener;
    private JmolCallbackListener jmolCallbackListener;
    private String statusList = "";
    private boolean allowStatusReporting;
    private Map<String, List<List<Object>>> messageQueue = new Hashtable<String, List<List<Object>>>();
    private int statusPtr = 0;
    private static int MAXIMUM_QUEUE_LENGTH = 16;
    private String[] jmolScriptCallbacks = new String[14];
    private int minSyncRepeatMs = 100;
    boolean syncingScripts = false;
    boolean syncingMouse = false;
    boolean drivingSync = false;
    boolean isSynced = false;
    boolean syncDisabled = false;
    boolean stereoSync = false;
    String inputFileName;
    String outputFileName;
    String dialogType;
    protected static final String[] imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM"};
    protected static final String[] imageExtensions = new String[]{"jpg", "png", "gif", "ppm"};
    int qualityJPG = -1;
    int qualityPNG = -1;
    String imageType;
    int imageQuality;

    StatusManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void setAllowStatusReporting(boolean bl) {
        this.allowStatusReporting = bl;
    }

    String getStatusList() {
        return this.statusList;
    }

    Map<String, List<List<Object>>> getMessageQueue() {
        return this.messageQueue;
    }

    private boolean recordStatus(String string) {
        return this.allowStatusReporting && this.statusList.length() > 0 && (this.statusList.equals("all") || this.statusList.indexOf(string) >= 0);
    }

    private synchronized void setStatusChanged(String string, int n, Object object, boolean bl) {
        List<List<Object>> list;
        if (!this.recordStatus(string)) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(++this.statusPtr);
        arrayList.add(string);
        arrayList.add(n);
        arrayList.add(object);
        List<List<Object>> list2 = list = bl ? null : this.messageQueue.get(string);
        if (list == null) {
            list = new ArrayList<List<Object>>();
            this.messageQueue.put(string, list);
        } else if (list.size() == MAXIMUM_QUEUE_LENGTH) {
            list.remove(0);
        }
        list.add(arrayList);
    }

    synchronized List<List<List<Object>>> getStatusChanged(String string) {
        boolean bl = string.length() > 0 && string.charAt(0) == '-';
        boolean bl2 = string.length() > 0 && string.charAt(0) == '+';
        boolean bl3 = false;
        if (bl) {
            this.statusList = TextFormat.simpleReplace(this.statusList, string.substring(1, string.length()), "");
        } else if (this.statusList.equals(string = TextFormat.simpleReplace(string, "+", "")) || bl2 && this.statusList.indexOf(string) >= 0) {
            bl3 = true;
        } else {
            if (!bl2) {
                this.statusList = "";
            }
            this.statusList = this.statusList + string;
            if (Logger.debugging) {
                Logger.debug("StatusManager messageQueue = " + this.statusList);
            }
        }
        ArrayList<List<List<Object>>> arrayList = bl3 ? Collections.list(Collections.enumeration(this.messageQueue.values())) : new ArrayList<List<List<Object>>>();
        this.messageQueue.clear();
        this.statusPtr = 0;
        return arrayList;
    }

    synchronized void setJmolStatusListener(JmolStatusListener jmolStatusListener, JmolCallbackListener jmolCallbackListener) {
        this.jmolStatusListener = jmolStatusListener;
        this.jmolCallbackListener = jmolCallbackListener == null ? jmolStatusListener : jmolCallbackListener;
    }

    private String jmolScriptCallback(int n) {
        String string = this.jmolScriptCallbacks[n];
        if (string != null) {
            this.viewer.evalStringQuiet(string, true, false);
        }
        return string;
    }

    synchronized void setCallbackFunction(String string, String string2) {
        int n = JmolConstants.getCallbackId(string);
        if (n >= 0) {
            int n2 = string2 == null ? 0 : (string2.length() > 7 && string2.toLowerCase().indexOf("script:") == 0 ? 7 : (string2.length() > 11 && string2.toLowerCase().indexOf("jmolscript:") == 0 ? 11 : 0));
            String string3 = this.jmolScriptCallbacks[n] = n2 == 0 ? null : string2.substring(n2).trim();
        }
        if (this.jmolCallbackListener != null) {
            this.jmolCallbackListener.setCallbackFunction(string, string2);
        }
    }

    private boolean notifyEnabled(int n) {
        return this.jmolCallbackListener != null && this.jmolCallbackListener.notifyEnabled(n);
    }

    synchronized void setStatusAtomPicked(int n, String string) {
        String string2 = this.jmolScriptCallback(9);
        Logger.info("setStatusAtomPicked(" + n + "," + string + ")");
        this.setStatusChanged("atomPicked", n, string, false);
        if (this.notifyEnabled(9)) {
            this.jmolCallbackListener.notifyCallback(9, new Object[]{string2, string, n});
        }
    }

    synchronized int setStatusClicked(int n, int n2, int n3, int n4, int n5) {
        String string = this.jmolScriptCallback(13);
        if (!this.notifyEnabled(13)) {
            return n3;
        }
        int[] nArray = new int[]{n3, n5};
        this.jmolCallbackListener.notifyCallback(13, new Object[]{string, n, n2, n3, n4, nArray});
        return nArray[0];
    }

    synchronized void setStatusResized(int n, int n2) {
        String string = this.jmolScriptCallback(10);
        if (this.notifyEnabled(10)) {
            this.jmolCallbackListener.notifyCallback(10, new Object[]{string, n, n2});
        }
    }

    synchronized void setStatusAtomHovered(int n, String string) {
        String string2 = this.jmolScriptCallback(4);
        if (this.notifyEnabled(4)) {
            this.jmolCallbackListener.notifyCallback(4, new Object[]{string2, string, n});
        }
    }

    synchronized void setFileLoadStatus(String string, String string2, String string3, String string4, int n, boolean bl) {
        Object object;
        if (string == null && "resetUndo".equals(string2)) {
            object = (JmolAppConsoleInterface)this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (object != null) {
                object.zap();
            }
            string2 = this.viewer.getZapName();
        }
        this.setStatusChanged("fileLoaded", n, string, false);
        if (string4 != null) {
            this.setStatusChanged("fileLoadError", n, string4, false);
        }
        object = this.jmolScriptCallback(5);
        if (bl && this.notifyEnabled(5)) {
            String string5 = (String)this.viewer.getParameter("_smilesString");
            if (string5.length() != 0) {
                string2 = string5;
            }
            this.jmolCallbackListener.notifyCallback(5, new Object[]{object, string, string2, string3, string4, n, this.viewer.getParameter("_modelNumber"), this.viewer.getModelNumberDotted(this.viewer.getModelCount() - 1)});
        }
    }

    synchronized void setStatusFrameChanged(int n, int n2, int n3, int n4, int n5) {
        if (this.viewer.getModelSet() == null) {
            return;
        }
        boolean bl = n <= -2;
        int n6 = n;
        if (bl) {
            n6 = -2 - n6;
        }
        this.setStatusChanged("frameChanged", n, n6 >= 0 ? this.viewer.getModelNumberDotted(n6) : "", false);
        String string = this.viewer.getMenuName(n6);
        String string2 = this.jmolScriptCallback(0);
        if (this.notifyEnabled(0)) {
            this.jmolCallbackListener.notifyCallback(0, new Object[]{string2, new int[]{n, n2, n3, n4, n5}, string});
        }
        if (this.viewer.jmolpopup != null && !bl) {
            this.viewer.jmolpopup.updateComputedMenus();
        }
    }

    synchronized void setScriptEcho(String string, boolean bl) {
        if (string == null) {
            return;
        }
        this.setStatusChanged("scriptEcho", 0, string, false);
        String string2 = this.jmolScriptCallback(1);
        if (this.notifyEnabled(1)) {
            this.jmolCallbackListener.notifyCallback(1, new Object[]{string2, string, bl ? 1 : 0});
        }
    }

    synchronized void setStatusMeasuring(String string, int n, String string2, float f) {
        this.setStatusChanged(string, n, string2, false);
        String string3 = null;
        if (string.equals("measureCompleted")) {
            Logger.info("measurement[" + n + "] = " + string2);
            string3 = this.jmolScriptCallback(6);
        } else if (string.equals("measurePicked")) {
            this.setStatusChanged("measurePicked", n, string2, false);
            Logger.info("measurePicked " + n + " " + string2);
        }
        if (this.notifyEnabled(6)) {
            this.jmolCallbackListener.notifyCallback(6, new Object[]{string3, string2, n, string, Float.valueOf(f)});
        }
    }

    synchronized void notifyError(String string, String string2, String string3) {
        String string4 = this.jmolScriptCallback(2);
        if (this.notifyEnabled(2)) {
            this.jmolCallbackListener.notifyCallback(2, new Object[]{string4, string, string2, this.viewer.getShapeErrorState(), string3});
        }
    }

    synchronized void setScriptStatus(String string, String string2, int n, String string3) {
        boolean bl;
        if (n < -1) {
            int n2 = -2 - n;
            this.setStatusChanged("scriptStarted", n2, string2, false);
            string = "script " + n2 + " started";
        } else if (string == null) {
            return;
        }
        String string4 = n == 0 ? this.jmolScriptCallback(11) : null;
        boolean bl2 = bl = string == "Script completed";
        if (this.recordStatus("script")) {
            boolean bl3 = string3 != null;
            this.setStatusChanged(bl3 ? "scriptError" : "scriptStatus", 0, string, false);
            if (bl3 || bl) {
                this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (bl3 ? " unsuccessfully: " + string : " successfully"), false);
            }
        }
        if (bl && this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
            Object[] objectArray = new Object[]{null, "script <exiting>", string2, -1, string3};
            if (this.notifyEnabled(11)) {
                this.jmolCallbackListener.notifyCallback(11, objectArray);
            }
            this.processScript(objectArray);
            string = "Jmol script completed.";
        }
        Object[] objectArray = new Object[]{string4, string, string2, bl ? -1 : n, string3};
        if (this.notifyEnabled(11)) {
            this.jmolCallbackListener.notifyCallback(11, objectArray);
        }
        this.processScript(objectArray);
    }

    private void processScript(Object[] objectArray) {
        int n = (Integer)objectArray[3];
        if (this.viewer.scriptEditor != null) {
            if (n > 0) {
                this.viewer.scriptEditor.notifyScriptTermination();
            } else if (n < 0) {
                if (n == -2) {
                    this.viewer.scriptEditor.notifyScriptStart();
                }
            } else if (this.viewer.scriptEditor.isVisible() && ((String)objectArray[2]).length() > 0) {
                this.viewer.scriptEditor.notifyContext((ScriptContext)this.viewer.getProperty("DATA_API", "scriptContext", null), objectArray);
            }
        }
        if (this.viewer.appConsole != null && n == 0) {
            String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
            this.viewer.appConsole.sendConsoleMessage(string);
        }
    }

    boolean doSync() {
        return this.isSynced && this.drivingSync && !this.syncDisabled;
    }

    synchronized void setSync(String string) {
        if (this.syncingMouse) {
            if (string != null) {
                this.syncSend(string, "*");
            }
        } else if (!this.syncingScripts) {
            this.syncSend("!" + this.viewer.getMoveToText((float)this.minSyncRepeatMs / 1000.0f), "*");
        }
    }

    void setSyncDriver(int n) {
        if (this.stereoSync && n != 4) {
            this.syncSend("SET_GRAPHICS_OFF", "*");
            this.stereoSync = false;
        }
        switch (n) {
            case 4: {
                if (!this.syncDisabled) {
                    return;
                }
                this.syncDisabled = false;
                break;
            }
            case 3: {
                this.syncDisabled = true;
                break;
            }
            case 5: {
                this.drivingSync = true;
                this.isSynced = true;
                this.stereoSync = true;
                break;
            }
            case 1: {
                this.drivingSync = true;
                this.isSynced = true;
                break;
            }
            case 2: {
                this.drivingSync = false;
                this.isSynced = true;
                break;
            }
            default: {
                this.drivingSync = false;
                this.isSynced = false;
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.viewer.getHtmlName() + " sync mode=" + n + "; synced? " + this.isSynced + "; driving? " + this.drivingSync + "; disabled? " + this.syncDisabled);
        }
    }

    void syncSend(String string, String string2) {
        if (this.notifyEnabled(12)) {
            this.jmolCallbackListener.notifyCallback(12, new Object[]{null, string, string2});
        }
    }

    int getSyncMode() {
        return !this.isSynced ? 0 : (this.drivingSync ? 1 : 2);
    }

    synchronized void showUrl(String string) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showUrl(string);
        }
    }

    float[][] functionXY(String string, int n, int n2) {
        return this.jmolStatusListener == null ? new float[Math.abs(n)][Math.abs(n2)] : this.jmolStatusListener.functionXY(string, n, n2);
    }

    float[][][] functionXYZ(String string, int n, int n2, int n3) {
        return this.jmolStatusListener == null ? new float[Math.abs(n)][Math.abs(n2)][Math.abs(n2)] : this.jmolStatusListener.functionXYZ(string, n, n2, n3);
    }

    String jsEval(String string) {
        return this.jmolStatusListener == null ? "" : this.jmolStatusListener.eval(string);
    }

    String createImage(String string, String string2, Object object, int n) {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.createImage(string, string2, object, n);
    }

    Map<String, Applet> getRegistryInfo() {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.getRegistryInfo();
    }

    static JmolDialogInterface newDialog(boolean bl) {
        JmolDialogInterface jmolDialogInterface = (JmolDialogInterface)Interface.getOptionInterface("export.dialog.Dialog");
        jmolDialogInterface.setupUI(bl);
        return jmolDialogInterface;
    }

    String dialogAsk(String string, String string2) {
        this.inputFileName = string2;
        this.dialogType = string;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (StatusManager.this.dialogType.equals("load")) {
                        StatusManager.this.outputFileName = StatusManager.newDialog(false).getOpenFileNameFromDialog(StatusManager.this.viewer.getAppletContext(), StatusManager.this.viewer, StatusManager.this.inputFileName, null, null, false);
                        return;
                    }
                    JmolDialogInterface jmolDialogInterface = StatusManager.newDialog(false);
                    if (StatusManager.this.dialogType.equals("save")) {
                        StatusManager.this.outputFileName = jmolDialogInterface.getSaveFileNameFromDialog(StatusManager.this.viewer, StatusManager.this.inputFileName, null);
                        return;
                    }
                    if (StatusManager.this.dialogType.startsWith("saveImage")) {
                        int n;
                        StatusManager.this.outputFileName = jmolDialogInterface.getImageFileNameFromDialog(StatusManager.this.viewer, StatusManager.this.inputFileName, StatusManager.this.imageType, imageChoices, imageExtensions, StatusManager.this.qualityJPG, StatusManager.this.qualityPNG);
                        StatusManager.this.qualityJPG = jmolDialogInterface.getQuality("JPG");
                        StatusManager.this.qualityPNG = jmolDialogInterface.getQuality("PNG");
                        String string = jmolDialogInterface.getType();
                        if (string != null) {
                            StatusManager.this.imageType = string;
                        }
                        if ((n = jmolDialogInterface.getQuality(string)) >= 0) {
                            StatusManager.this.imageQuality = n;
                        }
                        return;
                    }
                    StatusManager.this.outputFileName = null;
                }
            });
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
        }
        return this.outputFileName;
    }
}

