/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.view.GenerationBunnyNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;

public class PedigreeNode
extends PNode {
    private PBoundedNode child;
    private PBoundedNode textHolder = new PBoundedNode();
    private boolean showingBunny = false;

    public PedigreeNode() {
        PText pText = new PText(NaturalSelectionStrings.PEDIGREE_START_MESSAGE);
        pText.setFont(new PhetFont(24));
        this.textHolder.addChild(pText);
        this.textHolder.setOffset(-pText.getWidth() / 2.0, 10.0);
        this.addChild(this.textHolder);
    }

    public void reset() {
        this.removeChildren();
        this.addChild(this.textHolder);
    }

    private void removeChildren() {
        if (this.showingBunny) {
            this.showingBunny = false;
            this.removeChild(this.child);
        } else {
            this.removeChild(this.textHolder);
        }
    }

    public void displayBunny(Bunny bunny) {
        this.removeChildren();
        this.showingBunny = true;
        this.child = PedigreeNode.getBlock(bunny, 0, PedigreeNode.getBunnyMaxLevel(bunny));
        this.addChild(this.child);
    }

    private static double desiredBunnyWidth(int n) {
        if (n == 0) {
            return 50.0;
        }
        if (n == 1) {
            return 40.0;
        }
        if (n == 2) {
            return 30.0;
        }
        if (n == 3) {
            return 25.0;
        }
        if (n == 4) {
            return 15.0;
        }
        return 15.0;
    }

    private static double getVPad(int n) {
        return 10.0;
    }

    private static double getHPad(int n) {
        if (n == 0) {
            return 40.0;
        }
        if (n == 1) {
            return 30.0;
        }
        if (n == 2) {
            return 20.0;
        }
        if (n == 3) {
            return 15.0;
        }
        if (n == 4) {
            return 10.0;
        }
        return 10.0;
    }

    private static double getBunnyScale(GenerationBunnyNode generationBunnyNode, int n) {
        return PedigreeNode.desiredBunnyWidth(n) / generationBunnyNode.getBunnyWidth();
    }

    private static PPath line(double d, double d2, double d3, double d4) {
        PPath pPath = PPath.createLine((float)d, (float)d2, (float)d3, (float)d4);
        pPath.setStroke(new BasicStroke(1.0f));
        pPath.setPaint(new Color(0, 0, 0, 0));
        pPath.setStrokePaint(Color.BLACK);
        return pPath;
    }

    private static PBoundedNode getBlock(Bunny bunny, int n, int n2) {
        PBoundedNode pBoundedNode = new PBoundedNode();
        GenerationBunnyNode generationBunnyNode = new GenerationBunnyNode(bunny);
        generationBunnyNode.setSelected(bunny.isSelected());
        double d = PedigreeNode.getBunnyScale(generationBunnyNode, n);
        double d2 = d * generationBunnyNode.getBunnyWidth();
        double d3 = d * generationBunnyNode.getBunnyHeight();
        generationBunnyNode.scale(d);
        pBoundedNode.addChild(generationBunnyNode);
        pBoundedNode.setBunnyWidth(d2);
        pBoundedNode.setBunnyHeight(d3);
        if (n == n2) {
            generationBunnyNode.setOffset(-d2 / 2.0, 0.0);
            pBoundedNode.setBoundWidth(d2);
            pBoundedNode.setBoundHeight(d3);
        } else {
            PBoundedNode pBoundedNode2 = PedigreeNode.getBlock(bunny.getFather(), n + 1, n2);
            PBoundedNode pBoundedNode3 = PedigreeNode.getBlock(bunny.getMother(), n + 1, n2);
            double d4 = pBoundedNode2.getBoundWidth();
            double d5 = pBoundedNode2.getBoundHeight();
            double d6 = pBoundedNode3.getBoundWidth();
            double d7 = pBoundedNode3.getBoundHeight();
            double d8 = -PedigreeNode.getHPad(n2) / 2.0 - d4 / 2.0;
            pBoundedNode2.setOffset(d8, 0.0);
            double d9 = PedigreeNode.getHPad(n2) / 2.0 + d6 / 2.0;
            pBoundedNode3.setOffset(d9, 0.0);
            pBoundedNode.setBoundWidth(d4 + d6 + PedigreeNode.getHPad(n2));
            double d10 = d5 > d7 ? d5 : d7;
            double d11 = pBoundedNode2.getBunnyHeight() > pBoundedNode3.getBunnyHeight() ? pBoundedNode2.getBunnyHeight() : pBoundedNode3.getBunnyHeight();
            generationBunnyNode.setOffset(-d2 / 2.0, d10 + PedigreeNode.getVPad(n));
            pBoundedNode.setBoundHeight(d10 + PedigreeNode.getVPad(n) + d3);
            pBoundedNode.addChild(pBoundedNode2);
            pBoundedNode.addChild(pBoundedNode3);
            double d12 = d10 - d11 / 2.0;
            pBoundedNode.addChild(PedigreeNode.line(d8 + pBoundedNode2.getBunnyWidth() / 2.0 + 2.0, d12, d9 - pBoundedNode3.getBunnyWidth() / 2.0 - 2.0, d12));
            pBoundedNode.addChild(PedigreeNode.line(0.0, d12, 0.0, d10 + PedigreeNode.getVPad(n) - 2.0));
        }
        return pBoundedNode;
    }

    private static int getBunnyMaxLevel(Bunny bunny) {
        return PedigreeNode.getBunnyMaxLevel(bunny, 0);
    }

    private static int getBunnyMaxLevel(Bunny bunny, int n) {
        int n2;
        if (n == 4) {
            return n;
        }
        Bunny bunny2 = bunny.getFather();
        Bunny bunny3 = bunny.getMother();
        if (bunny2 == null || bunny3 == null) {
            return n;
        }
        int n3 = PedigreeNode.getBunnyMaxLevel(bunny2, n + 1);
        return n3 > (n2 = PedigreeNode.getBunnyMaxLevel(bunny3, n + 1)) ? n2 : n3;
    }

    private static class PBoundedNode
    extends PNode {
        private double boundWidth;
        private double boundHeight;
        private double bunnyWidth;
        private double bunnyHeight;

        private PBoundedNode() {
        }

        public double getBoundWidth() {
            return this.boundWidth;
        }

        public void setBoundWidth(double d) {
            this.boundWidth = d;
        }

        public double getBoundHeight() {
            return this.boundHeight;
        }

        public void setBoundHeight(double d) {
            this.boundHeight = d;
        }

        public double getBunnyWidth() {
            return this.bunnyWidth;
        }

        public void setBunnyWidth(double d) {
            this.bunnyWidth = d;
        }

        public double getBunnyHeight() {
            return this.bunnyHeight;
        }

        public void setBunnyHeight(double d) {
            this.bunnyHeight = d;
        }
    }
}

