/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view.sprites;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.model.Wolf;
import edu.colorado.phet.naturalselection.view.LandscapeNode;
import edu.colorado.phet.naturalselection.view.sprites.NaturalSelectionSprite;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PAffineTransform;

public class WolfNode
extends NaturalSelectionSprite
implements Wolf.Listener {
    private PNode wolfGraphic;
    private boolean flipped = false;
    private boolean flippedInit = false;
    private PImage wolfImage;

    public WolfNode(LandscapeNode landscapeNode, Point3D point3D) {
        super(landscapeNode, point3D);
        PNode pNode = new PNode();
        this.wolfGraphic = new PNode();
        this.wolfImage = NaturalSelectionResources.getImageNode("wolf_2.png");
        this.wolfGraphic.addChild(this.wolfImage);
        pNode.addChild(this.wolfGraphic);
        this.addChild(pNode);
        pNode.setOffset(-this.wolfImage.getWidth() / 2.0, -this.wolfImage.getHeight());
        this.rescale();
        this.setPickable(false);
    }

    public void setFlipped(boolean bl) {
        if (bl != this.flipped || !this.flippedInit) {
            this.flippedInit = true;
            if (bl) {
                this.wolfGraphic.setTransform(new PAffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
            } else {
                this.wolfGraphic.setTransform(new PAffineTransform(-1.0, 0.0, 0.0, 1.0, this.wolfImage.getWidth(), 0.0));
            }
        }
        this.flipped = bl;
    }

    public void setPosition(Point3D point3D) {
        if (point3D.getX() > this.getPosition().getX()) {
            this.setFlipped(false);
        } else if (point3D.getX() < this.getPosition().getX()) {
            this.setFlipped(true);
        }
        super.setPosition(point3D);
        this.rescale();
    }

    public void rescale() {
        double d = Wolf.wolfScale(this.getPosition());
        this.setScale(d);
    }

    public void onEvent(Wolf.Event event) {
        Wolf wolf = event.wolf;
        if (event.type == 0) {
            this.setPosition(wolf.getPosition());
            this.setFlipped(wolf.isFlipped());
        }
    }
}

