/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.preferences;

import edu.colorado.phet.common.phetcommon.application.PhetPersistenceDir;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Properties;

public class PhetPreferences {
    private static PhetPreferencesFile PREFERENCES_FILE;
    private static PhetPreferences instance;
    private final Properties properties = new Properties();

    public static void clear() {
        PREFERENCES_FILE.clear();
    }

    public static File getPreferencesFile() {
        return PREFERENCES_FILE;
    }

    private PhetPreferences() {
        if (PREFERENCES_FILE != null) {
            this.initPreferencesFile();
            try {
                this.properties.load(new FileInputStream(PREFERENCES_FILE));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void initPreferencesFile() {
        if (!PREFERENCES_FILE.exists()) {
            PREFERENCES_FILE.getParentFile().mkdirs();
            this.setPreferencesFileCreationTimeNow();
            this.setUpdatesEnabled(true);
            this.setStatisticsEnabled(true);
            this.setAlwaysShowSoftwareAgreement(false);
        }
    }

    public static PhetPreferences getInstance() {
        if (instance == null) {
            instance = new PhetPreferences();
        }
        return instance;
    }

    public void setStatisticsEnabled(boolean bl) {
        this.setBooleanProperty("all-sims.statistics.enabled", bl);
    }

    public boolean isStatisticsEnabled() {
        return this.getBooleanProperty("all-sims.statistics.enabled");
    }

    public void setUpdatesEnabled(boolean bl) {
        this.setBooleanProperty("all-sims.updates.enabled", bl);
    }

    public boolean isUpdatesEnabled() {
        return this.getBooleanProperty("all-sims.updates.enabled");
    }

    public void setSimAskMeLater(String string, String string2, long l) {
        this.setStringProperty(PhetPreferences.getSimAskMeLaterKey(string, string2), String.valueOf(l));
    }

    public long getSimAskMeLater(String string, String string2) {
        return this.getLongProperty(PhetPreferences.getSimAskMeLaterKey(string, string2), 0L);
    }

    private static String getSimAskMeLaterKey(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return MessageFormat.format("{0}.{1}.updates.ask-me-later-pressed.milliseconds", objectArray);
    }

    public void setSimSkipUpdate(String string, String string2, int n) {
        this.setStringProperty(PhetPreferences.getSimSkipUpdateKey(string, string2), String.valueOf(n));
    }

    public int getSimSkipUpdate(String string, String string2) {
        return this.getIntProperty(PhetPreferences.getSimSkipUpdateKey(string, string2), 0);
    }

    private static String getSimSkipUpdateKey(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return MessageFormat.format("{0}.{1}.updates.skip.version", objectArray);
    }

    public void setInstallerAskMeLater(long l) {
        this.setStringProperty("installer.updates.ask-me-later-pressed.milliseconds", String.valueOf(l));
    }

    public long getInstallerAskMeLater() {
        return this.getLongProperty("installer.updates.ask-me-later-pressed.milliseconds", 0L);
    }

    public void setSoftwareAgreementVersion(int n) {
        this.setIntProperty("all-sims.software-agreement-version", n);
    }

    public int getSoftwareAgreementVersion() {
        return this.getIntProperty("all-sims.software-agreement-version", -1);
    }

    private long setPreferencesFileCreationTimeNow() {
        long l = System.currentTimeMillis();
        this.setLongProperty("preferences-file-creation-time.milliseconds", l);
        return l;
    }

    public long getPreferencesFileCreationTime() {
        return this.getLongProperty("preferences-file-creation-time.milliseconds", 0L);
    }

    public boolean isAlwaysShowSoftwareAgreement() {
        return this.getBooleanProperty("dev.always-show-software-agreement");
    }

    public void setAlwaysShowSoftwareAgreement(boolean bl) {
        this.setBooleanProperty("dev.always-show-software-agreement", bl);
    }

    private void setStringProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
        this.storePreferences();
    }

    private String getStringProperty(String string) {
        return this.properties.getProperty(string);
    }

    private void setBooleanProperty(String string, boolean bl) {
        this.setStringProperty(string, String.valueOf(bl));
    }

    private boolean getBooleanProperty(String string) {
        return Boolean.valueOf(this.getStringProperty(string));
    }

    private void setLongProperty(String string, long l) {
        this.setStringProperty(string, String.valueOf(l));
    }

    private long getLongProperty(String string, long l) {
        long l2 = l;
        String string2 = this.properties.getProperty(string);
        if (string2 != null) {
            try {
                l2 = Long.parseLong(this.properties.getProperty(string));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return l2;
    }

    private void setIntProperty(String string, int n) {
        this.setStringProperty(string, String.valueOf(n));
    }

    private int getIntProperty(String string, int n) {
        int n2 = n;
        String string2 = this.properties.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(this.properties.getProperty(string));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return n2;
    }

    private void storePreferences() {
        if (PREFERENCES_FILE != null) {
            try {
                this.properties.store(new FileOutputStream(PREFERENCES_FILE), "Preferences for PhET, see http://phet.colorado.edu");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.properties.toString();
    }

    static {
        try {
            PREFERENCES_FILE = new PhetPreferencesFile();
        }
        catch (AccessControlException accessControlException) {
            PREFERENCES_FILE = null;
            System.out.println("PhetPreferences: access to local filesystem denied");
        }
    }

    private static class PhetPreferencesFile
    extends File {
        public PhetPreferencesFile() throws AccessControlException {
            super(new PhetPersistenceDir(), "preferences.properties");
        }

        public void clear() {
            boolean bl = this.delete();
            if (!bl) {
                this.deleteOnExit();
                System.out.println("delete failed, will try again on exit");
            } else {
                System.out.println("preferences file deleted, you should probably exit now");
                PREFERENCES_FILE = null;
            }
        }
    }
}

