/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.help;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractHelpItem
extends PNode {
    private JComponent _helpPane;
    private IFollower _follower;
    private boolean _enabled;

    public AbstractHelpItem(JComponent jComponent) {
        this._helpPane = jComponent;
        this.setEnabled(false);
    }

    public void updatePosition() {
        if (this._follower != null) {
            this._follower.updatePosition();
        }
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        if (this._follower != null) {
            this._follower.setFollowEnabled(bl);
        } else {
            this.setVisible(bl);
        }
        if (!bl) {
            this.setVisible(false);
        }
    }

    public static boolean isNodeVisible(PNode pNode) {
        boolean bl = pNode.getVisible();
        PNode pNode2 = pNode;
        while (bl && pNode2 != null) {
            if ((pNode2 = pNode2.getParent()) == null) continue;
            bl = pNode2.getVisible();
        }
        return bl;
    }

    public void setLocation(double d, double d2) {
        this.pointAt(d, d2);
    }

    public void pointAt(double d, double d2) {
        this.setOffset(d, d2);
    }

    public void pointAt(PNode pNode, PCanvas pCanvas) {
        if (!AbstractHelpItem.nodeIsOnCanvas(pNode, pCanvas)) {
            throw new IllegalArgumentException("node is not on canvas");
        }
        if (this._follower != null) {
            this._follower.setFollowEnabled(false);
        }
        this._follower = new PNodeFollower(this, pNode, pCanvas);
        this._follower.setFollowEnabled(this._enabled);
    }

    private static boolean nodeIsOnCanvas(PNode pNode, PCanvas pCanvas) {
        boolean bl = false;
        PCamera pCamera = pCanvas.getCamera();
        int n = pCamera.getLayerCount();
        for (int i = 0; i < n && !bl; ++i) {
            bl = pNode.isDescendentOf(pCamera.getLayer(i));
        }
        return bl;
    }

    public void pointAt(JComponent jComponent) {
        if (this._follower != null) {
            this._follower.setFollowEnabled(false);
        }
        this._follower = new JComponentFollower(this, jComponent);
        this._follower.setFollowEnabled(this._enabled);
    }

    public void pointAt(JComponent jComponent, PSwing pSwing, PCanvas pCanvas) {
        if (!SwingUtilities.isDescendingFrom(jComponent, pSwing.getComponent())) {
            throw new IllegalArgumentException("component is not embedded in pswing");
        }
        if (!pSwing.isDescendentOf(pCanvas.getLayer())) {
            throw new IllegalArgumentException("pswing is not on canvas");
        }
        if (this._follower != null) {
            this._follower.setFollowEnabled(false);
        }
        this._follower = new EmbeddedJComponentFollower(this, jComponent, pSwing, pCanvas);
        this._follower.setFollowEnabled(this._enabled);
    }

    public Point2D mapLocation(PNode pNode, PCanvas pCanvas) {
        int n = 0;
        int n2 = 0;
        Cloneable cloneable = pNode.getFullBounds();
        Rectangle2D rectangle2D = pNode.getParent().localToGlobal((Rectangle2D)cloneable);
        PCamera pCamera = pCanvas.getCamera();
        PAffineTransform pAffineTransform = pCamera.getViewTransformReference();
        Rectangle2D rectangle2D2 = pAffineTransform.transform(rectangle2D, null);
        n = (int)rectangle2D2.getX();
        n2 = (int)rectangle2D2.getY();
        cloneable = SwingUtilities.convertPoint(pCanvas, n, n2, this._helpPane);
        return cloneable;
    }

    public Point2D mapLocation(JComponent jComponent) {
        return SwingUtilities.convertPoint(jComponent.getParent(), jComponent.getLocation(), this._helpPane);
    }

    public Point2D mapLocation(JComponent jComponent, PSwing pSwing, PCanvas pCanvas) {
        Object object;
        Point2D point2D = null;
        if (jComponent == pSwing.getComponent()) {
            point2D = new Point2D.Double(0.0, 0.0);
        } else if (jComponent.getParent() == pSwing.getComponent()) {
            point2D = jComponent.getLocation();
        } else {
            object = pSwing.getComponent();
            point2D = SwingUtilities.convertPoint(jComponent.getParent(), jComponent.getLocation(), (Component)object);
        }
        object = null;
        Point2D point2D2 = pSwing.localToGlobal(point2D);
        PCamera pCamera = pCanvas.getCamera();
        PAffineTransform pAffineTransform = pCamera.getViewTransformReference();
        object = pAffineTransform.transform(point2D2, null);
        point2D2 = SwingUtilities.convertPoint(pCanvas, (int)((Point2D)object).getX(), (int)((Point2D)object).getY(), this._helpPane);
        return point2D2;
    }

    private static class EmbeddedJComponentFollower
    implements IFollower,
    ComponentListener,
    PropertyChangeListener {
        private AbstractHelpItem _helpItem;
        private JComponent _component;
        private PSwing _pswing;
        private PCanvas _canvas;
        private ArrayList _watchList;

        public EmbeddedJComponentFollower(AbstractHelpItem abstractHelpItem, JComponent jComponent, PSwing pSwing, PCanvas pCanvas) {
            this._helpItem = abstractHelpItem;
            this._component = jComponent;
            this._pswing = pSwing;
            this._canvas = pCanvas;
            this._watchList = new ArrayList();
            this.setFollowEnabled(false);
        }

        public void setFollowEnabled(boolean bl) {
            if (bl) {
                this._component.addComponentListener(this);
                this.updateWatchList();
                this.updateVisibility();
                this.updatePosition();
            } else {
                this._component.removeComponentListener(this);
                this.clearWatchList();
            }
        }

        public void updateVisibility() {
            boolean bl = this._component.isVisible() && AbstractHelpItem.isNodeVisible(this._pswing);
            this._helpItem.setVisible(bl);
        }

        public void updatePosition() {
            if (this._helpItem.getVisible()) {
                Point2D point2D = this._helpItem.mapLocation(this._component, this._pswing, this._canvas);
                this._helpItem.setOffset(point2D);
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.updatePosition();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.updatePosition();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.updateVisibility();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.updateVisibility();
            this.updatePosition();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("parent".equals(string)) {
                this.updateWatchList();
                this.updateVisibility();
                this.updatePosition();
            } else if ("visible".equals(string)) {
                this.updateVisibility();
                this.updatePosition();
            } else {
                this.updatePosition();
            }
        }

        private void updateWatchList() {
            this.clearWatchList();
            for (PNode pNode = this._pswing; pNode != null; pNode = pNode.getParent()) {
                pNode.addPropertyChangeListener(this);
                this._watchList.add(pNode);
            }
        }

        private void clearWatchList() {
            Iterator iterator = this._watchList.iterator();
            while (iterator.hasNext()) {
                ((PNode)iterator.next()).removePropertyChangeListener(this);
            }
            this._watchList.clear();
        }
    }

    public static interface IFollower {
        public void setFollowEnabled(boolean var1);

        public void updatePosition();
    }

    public static class JComponentFollower
    implements IFollower,
    ComponentListener {
        private AbstractHelpItem _helpItem;
        private JComponent _component;

        public JComponentFollower(AbstractHelpItem abstractHelpItem, JComponent jComponent) {
            this._helpItem = abstractHelpItem;
            this._component = jComponent;
            this.setFollowEnabled(false);
        }

        public void setFollowEnabled(boolean bl) {
            if (bl) {
                this._component.addComponentListener(this);
                this.updateVisibility();
                this.updatePosition();
            } else {
                this._component.removeComponentListener(this);
            }
        }

        public void updateVisibility() {
            this._helpItem.setVisible(this._component.isVisible());
        }

        public void updatePosition() {
            if (this._helpItem.getVisible()) {
                Point2D point2D = this._helpItem.mapLocation(this._component);
                this._helpItem.setOffset(point2D.getX(), point2D.getY());
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.updatePosition();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.updatePosition();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.updateVisibility();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.updateVisibility();
            this.updatePosition();
        }
    }

    private static class PNodeFollower
    implements IFollower,
    PropertyChangeListener {
        private AbstractHelpItem _helpItem;
        private PNode _node;
        private PCanvas _canvas;
        private ArrayList _watchList;

        public PNodeFollower(AbstractHelpItem abstractHelpItem, PNode pNode, PCanvas pCanvas) {
            this._helpItem = abstractHelpItem;
            this._node = pNode;
            this._canvas = pCanvas;
            this._watchList = new ArrayList();
            this.setFollowEnabled(false);
        }

        public void setFollowEnabled(boolean bl) {
            if (bl) {
                this.updateWatchList();
                this.updateVisibility();
                this.updatePosition();
            } else {
                this.clearWatchList();
            }
        }

        public void updateVisibility() {
            boolean bl = AbstractHelpItem.isNodeVisible(this._node);
            this._helpItem.setVisible(bl);
        }

        public void updatePosition() {
            if (this._helpItem.getVisible()) {
                Point2D point2D = this._helpItem.mapLocation(this._node, this._canvas);
                this._helpItem.setOffset(point2D);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("parent".equals(string)) {
                this.updateWatchList();
                this.updateVisibility();
                this.updatePosition();
            } else if ("visible".equals(string)) {
                this.updateVisibility();
                this.updatePosition();
            } else {
                this.updatePosition();
            }
        }

        private void updateWatchList() {
            this.clearWatchList();
            for (PNode pNode = this._node; pNode != null; pNode = pNode.getParent()) {
                pNode.addPropertyChangeListener(this);
                this._watchList.add(pNode);
            }
        }

        private void clearWatchList() {
            Iterator iterator = this._watchList.iterator();
            while (iterator.hasNext()) {
                ((PNode)iterator.next()).removePropertyChangeListener(this);
            }
            this._watchList.clear();
        }
    }
}

