/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import edu.colorado.phet.naturalselection.util.ImagePanel;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ClimatePanel
extends JPanel {
    private JRadioButton equatorButton;
    private JRadioButton arcticButton;

    public ClimatePanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.equatorButton = new JRadioButton(NaturalSelectionStrings.EQUATOR);
        jPanel.add(this.equatorButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        ImagePanel imagePanel = new ImagePanel("equator-environment.png");
        jPanel.add(imagePanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.arcticButton = new JRadioButton(NaturalSelectionStrings.ARCTIC);
        jPanel2.add(this.arcticButton);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        ImagePanel imagePanel2 = new ImagePanel("arctic-environment.png");
        jPanel2.add(imagePanel2);
        JLabel jLabel = new JLabel(NaturalSelectionStrings.ENVIRONMENT);
        jLabel.setFont(new PhetFont(12, true));
        jPanel.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        this.add(Box.createRigidArea(new Dimension(5, 2)));
        this.add(jPanel);
        this.add(jPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.equatorButton);
        buttonGroup.add(this.arcticButton);
        this.selectDefaultClimate();
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.equatorButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        jPanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        imagePanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.arcticButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        jPanel2.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        imagePanel2.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
    }

    public void selectDefaultClimate() {
        int n = 0;
        this.setClimate(n);
    }

    private void setClimate(int n) {
        if (n == 0) {
            this.equatorButton.setSelected(true);
        } else if (n == 1) {
            this.arcticButton.setSelected(true);
        }
    }

    public void reset() {
        this.selectDefaultClimate();
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.setClimate(naturalSelectionConfig.getClimate());
    }

    public JRadioButton getEquatorButton() {
        return this.equatorButton;
    }

    public JRadioButton getArcticButton() {
        return this.arcticButton;
    }
}

