/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import edu.colorado.phet.naturalselection.util.ImagePanel;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectionPanel
extends JPanel {
    private JRadioButton wolvesButton;
    private JRadioButton foodButton;
    private JRadioButton noneButton;

    public SelectionPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.wolvesButton = new JRadioButton(NaturalSelectionStrings.WOLVES);
        jPanel.add(this.wolvesButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        ImagePanel imagePanel = new ImagePanel("selection_wolves.png");
        jPanel.add(imagePanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.foodButton = new JRadioButton(NaturalSelectionStrings.FOOD);
        jPanel2.add(this.foodButton);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        ImagePanel imagePanel2 = new ImagePanel("selection_food.png");
        jPanel2.add(imagePanel2);
        this.noneButton = new JRadioButton(NaturalSelectionStrings.NONE);
        JLabel jLabel = new JLabel(NaturalSelectionStrings.SELECTION_FACTOR);
        jLabel.setFont(new PhetFont(12, true));
        jPanel.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jLabel.setAlignmentX(0.0f);
        this.noneButton.setAlignmentX(0.0f);
        this.add(jLabel);
        this.add(Box.createRigidArea(new Dimension(5, 2)));
        this.add(jPanel);
        this.add(jPanel2);
        this.add(this.noneButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.wolvesButton);
        buttonGroup.add(this.foodButton);
        buttonGroup.add(this.noneButton);
        this.selectDefaultSelectionFactor();
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.wolvesButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        jPanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        imagePanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.foodButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        jPanel2.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        imagePanel2.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.noneButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
    }

    public void selectDefaultSelectionFactor() {
        int n = 0;
        this.setSelectionFactor(n);
    }

    private void setSelectionFactor(int n) {
        if (n == 2) {
            this.wolvesButton.setSelected(true);
        } else if (n == 1) {
            this.foodButton.setSelected(true);
        } else if (n == 0) {
            this.noneButton.setSelected(true);
        }
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.setSelectionFactor(naturalSelectionConfig.getSelectionFactor());
    }

    public JRadioButton getWolvesButton() {
        return this.wolvesButton;
    }

    public JRadioButton getFoodButton() {
        return this.foodButton;
    }

    public JRadioButton getNoneButton() {
        return this.noneButton;
    }
}

