/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.defaults.NaturalSelectionDefaults;
import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.Gene;

public class ColorGene
extends Gene {
    public static final Allele WHITE_ALLELE = new Allele(NaturalSelectionStrings.GENE_COLOR_WHITE);
    public static final Allele BROWN_ALLELE = new Allele(NaturalSelectionStrings.GENE_COLOR_BROWN);
    private static ColorGene instance = null;

    private ColorGene() {
        super(WHITE_ALLELE, BROWN_ALLELE, NaturalSelectionDefaults.COLOR_DOMINANT_ALLELE);
        this.setDominantAllele(BROWN_ALLELE);
    }

    public static ColorGene getInstance() {
        if (instance == null) {
            instance = new ColorGene();
        }
        return instance;
    }

    public Allele getBunnyPhenotype(Bunny bunny) {
        return bunny.getColorPhenotype();
    }
}

