/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.GeneListener;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Gene
implements Bunny.Listener {
    private Allele primaryAllele;
    private Allele secondaryAllele;
    private int primaryCount = 0;
    private int secondaryCount = 0;
    private Allele dominantAllele;
    private Allele defaultDominantAllele;
    private boolean mutatable;
    private NaturalSelectionModel model;
    private List<GeneListener> listeners;

    protected Gene(Allele allele, Allele allele2, Allele allele3) {
        this.primaryAllele = allele;
        this.secondaryAllele = allele2;
        this.defaultDominantAllele = allele3;
        this.dominantAllele = allele3;
        this.listeners = new LinkedList<GeneListener>();
    }

    public void reset() {
        this.dominantAllele = this.defaultDominantAllele;
        this.secondaryCount = 0;
        this.primaryCount = 0;
        this.mutatable = false;
    }

    public void setModel(NaturalSelectionModel naturalSelectionModel) {
        this.model = naturalSelectionModel;
    }

    public Allele getPrimaryAllele() {
        return this.primaryAllele;
    }

    public Allele getSecondaryAllele() {
        return this.secondaryAllele;
    }

    public Allele getDominantAllele() {
        return this.dominantAllele;
    }

    public void setDominantAllele(Allele allele) {
        if (this.dominantAllele == allele) {
            return;
        }
        if (allele != this.primaryAllele && allele != this.secondaryAllele) {
            System.out.println("WARNING: Attempting to set a dominant allele that is unrelated.");
            return;
        }
        this.dominantAllele = allele;
        this.notifyChangeDominantAllele();
        this.refreshPhenotypeCount();
    }

    public int getPrimaryPhenotypeCount() {
        return this.primaryCount;
    }

    public int getSecondaryPhenotypeCount() {
        return this.secondaryCount;
    }

    public void refreshPhenotypeCount() {
        if (this.model == null) {
            return;
        }
        int n = this.primaryCount;
        int n2 = this.secondaryCount;
        this.primaryCount = 0;
        this.secondaryCount = 0;
        List<Bunny> list = this.model.getAliveBunnyList();
        for (Bunny bunny : list) {
            Allele allele = this.getBunnyPhenotype(bunny);
            if (allele == this.primaryAllele) {
                ++this.primaryCount;
                continue;
            }
            if (allele == this.secondaryAllele) {
                ++this.secondaryCount;
                continue;
            }
            throw new RuntimeException("Cannot get a count for unrelated allele");
        }
        if (n != this.primaryCount || n2 != this.secondaryCount) {
            this.notifyChangeDistribution();
        }
    }

    public boolean getMutatable() {
        return this.mutatable;
    }

    public void setMutatable(boolean bl) {
        boolean bl2 = this.mutatable;
        this.mutatable = bl;
        if (bl2 != this.mutatable) {
            this.notifyChangeMutatable();
        }
    }

    public abstract Allele getBunnyPhenotype(Bunny var1);

    public void onEvent(Bunny.Event event) {
        Bunny bunny = event.getBunny();
        switch (event.type) {
            case 0: {
                if (this.getBunnyPhenotype(bunny) == this.primaryAllele) {
                    ++this.primaryCount;
                } else {
                    ++this.secondaryCount;
                }
                this.notifyChangeDistribution();
                break;
            }
            case 1: {
                this.refreshPhenotypeCount();
            }
        }
    }

    private void notifyChangeDistribution() {
        Iterator<GeneListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onChangeDistribution(this, this.getPrimaryPhenotypeCount(), this.getSecondaryPhenotypeCount());
        }
    }

    private void notifyChangeDominantAllele() {
        Iterator<GeneListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onChangeDominantAllele(this, this.primaryAllele == this.dominantAllele);
        }
    }

    private void notifyChangeMutatable() {
        Iterator<GeneListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onChangeMutatable(this, this.getMutatable());
        }
    }

    public void addListener(GeneListener geneListener) {
        this.listeners.add(geneListener);
    }
}

