/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.module;

import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.control.NaturalSelectionControlPanel;
import edu.colorado.phet.naturalselection.dialog.BunniesTakeOverDialog;
import edu.colorado.phet.naturalselection.dialog.GameOverDialog;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.NaturalSelectionClock;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.module.NaturalSelectionController;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import edu.colorado.phet.naturalselection.view.NaturalSelectionCanvas;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class NaturalSelectionModule
extends PiccoloModule {
    private NaturalSelectionModel model;
    private NaturalSelectionCanvas canvas;
    private NaturalSelectionControlPanel controlPanel;
    private GameOverDialog gameOverDialog;
    private BunniesTakeOverDialog bunniesTakeOverDialog;
    private Frame parentFrame;
    private static NaturalSelectionModule module;

    public NaturalSelectionModule(Frame frame) {
        super(NaturalSelectionStrings.TITLE_NATURAL_SELECTION_MODULE, new NaturalSelectionClock(NaturalSelectionConstants.getSettings().getClockFrameRate(), NaturalSelectionConstants.getSettings().getClockDT()));
        module = this;
        this.parentFrame = frame;
        NaturalSelectionClock naturalSelectionClock = (NaturalSelectionClock)this.getClock();
        this.model = new NaturalSelectionModel(naturalSelectionClock);
        this.canvas = new NaturalSelectionCanvas(this.model);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new NaturalSelectionControlPanel(this);
        this.getModulePanel().setClockControlPanelWithoutContainer(this.controlPanel);
        NaturalSelectionController naturalSelectionController = new NaturalSelectionController(this.model, this.canvas, this.controlPanel, this);
        this.model.initialize();
    }

    public void reset() {
        super.reset();
        Bunny.bunnyCount = 0;
        this.controlPanel.reset();
        this.canvas.reset();
        this.model.reset();
        this.gameOverDialog = null;
    }

    public void save(NaturalSelectionConfig naturalSelectionConfig) {
        this.model.save(naturalSelectionConfig);
        this.controlPanel.save(naturalSelectionConfig);
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.reset();
        this.model.load(naturalSelectionConfig);
        this.controlPanel.load(naturalSelectionConfig);
        this.canvas.load(naturalSelectionConfig);
    }

    public void showGameOver() {
        if (this.gameOverDialog == null) {
            this.gameOverDialog = new GameOverDialog(this.parentFrame, this);
            SwingUtils.centerDialogInParent(this.gameOverDialog);
            this.gameOverDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NaturalSelectionModule.this.gameOverDialog.dispose();
                }

                public void windowClosed(WindowEvent windowEvent) {
                    NaturalSelectionModule.this.gameOverDialog = null;
                }
            });
            this.gameOverDialog.setVisible(true);
        }
    }

    public void showBunniesTakeOver() {
        if (this.bunniesTakeOverDialog == null) {
            this.bunniesTakeOverDialog = new BunniesTakeOverDialog(this.parentFrame, this);
            SwingUtils.centerDialogInParent(this.bunniesTakeOverDialog);
            this.bunniesTakeOverDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NaturalSelectionModule.this.bunniesTakeOverDialog.dispose();
                }

                public void windowClosed(WindowEvent windowEvent) {
                    NaturalSelectionModule.this.bunniesTakeOverDialog = null;
                }
            });
            this.bunniesTakeOverDialog.setVisible(true);
        }
    }

    public NaturalSelectionModel getMyModel() {
        return this.model;
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public static NaturalSelectionModule getModule() {
        return module;
    }
}

