/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.colorado.phet.naturalselection.util.HighContrastImageFilter;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.BasicStroke;
import java.awt.Color;

public class DisplayBunnyNode
extends PNode {
    private PImage image;
    private PImage mutatedImage;
    private PPath deadX;
    private PPath selectedBorder;
    private Allele color;
    private Allele teeth;
    private Allele tail;
    private boolean dead = false;
    private boolean selected = false;
    private boolean flipped = false;

    public DisplayBunnyNode(Allele allele, Allele allele2, Allele allele3) {
        this.color = allele;
        this.teeth = allele2;
        this.tail = allele3;
        String string = "bunny";
        string = allele == ColorGene.WHITE_ALLELE ? string + "_white" : string + "_brown";
        if (allele3 == TailGene.TAIL_LONG_ALLELE) {
            string = string + "_big_tail";
        }
        if (allele2 == TeethGene.TEETH_LONG_ALLELE) {
            string = string + "_long_teeth";
        }
        string = string + ".png";
        this.image = NaturalSelectionResources.getImageNode(string);
        if (NaturalSelectionApplication.isHighContrast()) {
            this.image = allele == ColorGene.WHITE_ALLELE ? HighContrastImageFilter.getWhiteBunny().getPImage(string) : HighContrastImageFilter.getBrownBunny().getPImage(string);
        }
        this.addChild(this.image);
        this.initDeadX();
        this.addChild(this.deadX);
        this.initSelectedBorder();
        this.addChild(this.selectedBorder);
        this.setDead(false);
        this.setSelected(false);
    }

    private void initDeadX() {
        this.deadX = new PPath();
        this.deadX.setStroke(new BasicStroke(20.0f));
        this.deadX.setStrokePaint(Color.RED);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(0.0, 0.0);
        doubleGeneralPath.lineTo(this.getBunnyWidth(), this.getBunnyHeight());
        doubleGeneralPath.moveTo(this.getBunnyWidth(), 0.0);
        doubleGeneralPath.lineTo(0.0, this.getBunnyHeight());
        this.deadX.setPathTo(doubleGeneralPath.getGeneralPath());
        this.deadX.scale(0.5);
    }

    private void initSelectedBorder() {
        float f = 7.0f;
        this.selectedBorder = PPath.createRectangle(-f, -f, (float)this.getBunnyWidth() + 2.0f * f, (float)this.getBunnyHeight() + 2.0f * f);
        this.selectedBorder.setStroke(new BasicStroke(7.0f));
        this.selectedBorder.setStrokePaint(Color.BLUE);
        this.selectedBorder.setPaint(new Color(0, 0, 0, 0));
    }

    public void setMutated() {
        this.mutatedImage = NaturalSelectionResources.getImageNode("mutation_very_large.png");
        this.mutatedImage.setOffset(this.getBunnyWidth() / 2.0, -this.getBunnyHeight() / 5.0);
        this.mutatedImage.setScale(1.3);
        this.addChild(this.mutatedImage);
    }

    public void setFlipped(boolean bl) {
        if (bl != this.flipped) {
            if (bl) {
                this.setTransform(new PAffineTransform(-1.0, 0.0, 0.0, 1.0, this.getBunnyWidth(), 0.0));
            } else {
                this.setTransform(new PAffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
            }
        }
        this.flipped = bl;
    }

    public void setDead(boolean bl) {
        this.dead = bl;
        this.deadX.setVisible(bl);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.selectedBorder.setVisible(bl);
    }

    public double getBunnyWidth() {
        return this.image.getWidth();
    }

    public double getBunnyHeight() {
        return this.image.getHeight();
    }
}

