/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.defaults.NaturalSelectionDefaults;
import edu.colorado.phet.naturalselection.model.Gene;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import edu.colorado.phet.naturalselection.view.AddFriendNode;
import edu.colorado.phet.naturalselection.view.LandscapeNode;
import edu.colorado.phet.naturalselection.view.MutationPendingNode;
import edu.colorado.phet.naturalselection.view.NaturalSelectionBackgroundNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;

public class NaturalSelectionCanvas
extends PhetPCanvas {
    private NaturalSelectionModel model;
    private PNode rootNode;
    public LandscapeNode landscapeNode;
    public NaturalSelectionBackgroundNode backgroundNode;
    private MutationPendingNode mutationPendingNode = null;
    private AddFriendNode addFriendNode;

    public NaturalSelectionCanvas(NaturalSelectionModel naturalSelectionModel) {
        super(NaturalSelectionDefaults.VIEW_SIZE);
        this.setWorldTransformStrategy(new PhetPCanvas.ConstantTransformStrategy(new AffineTransform()));
        this.model = naturalSelectionModel;
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        this.backgroundNode = new NaturalSelectionBackgroundNode(this.model.getClimate());
        this.rootNode.addChild(this.backgroundNode);
        this.landscapeNode = new LandscapeNode(naturalSelectionModel, naturalSelectionModel.getLandscape());
        this.rootNode.addChild(this.landscapeNode);
        this.addFriendNode = new AddFriendNode(naturalSelectionModel);
        this.addFriendNode.setOffset(75.0, 250.0);
        this.rootNode.addChild(this.addFriendNode);
    }

    public void reset() {
        this.landscapeNode.reset();
        this.backgroundNode.reset();
        this.addFriendNode.setVisible(true);
        if (this.mutationPendingNode != null) {
            this.rootNode.removeChild(this.mutationPendingNode);
        }
        this.mutationPendingNode = null;
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
        this.backgroundNode.updateLayout(this.getWidth(), this.getHeight());
        this.landscapeNode.setSpriteTransform(this.backgroundNode.getBackgroundTransform(this.getWidth(), this.getHeight()));
        this.landscapeNode.updateLayout(this.getWidth(), this.getHeight());
        this.addFriendNode.updateLayout(this.getWidth(), this.getHeight());
        this.positionMutationPending();
    }

    public void handleMutationChange(Gene gene, boolean bl) {
        if (bl) {
            if (this.mutationPendingNode != null) {
                throw new RuntimeException("mutationPendingNode should be null!!!");
            }
            this.mutationPendingNode = new MutationPendingNode(gene);
            this.positionMutationPending();
            this.rootNode.addChild(this.mutationPendingNode);
        } else if (this.mutationPendingNode != null) {
            this.rootNode.removeChild(this.mutationPendingNode);
            this.mutationPendingNode = null;
        }
    }

    private void positionMutationPending() {
        if (this.mutationPendingNode == null) {
            return;
        }
        this.mutationPendingNode.setOffset(((double)this.getWidth() - this.mutationPendingNode.getPlacementWidth()) / 2.0, (double)this.getHeight() - this.mutationPendingNode.getPlacementHeight() - 10.0);
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.addFriendNode.setVisible(!naturalSelectionConfig.isFriendAdded());
    }

    public LandscapeNode getLandscapeNode() {
        return this.landscapeNode;
    }
}

