/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view.sprites;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.naturalselection.view.LandscapeNode;
import java.util.LinkedList;
import java.util.List;

public abstract class NaturalSelectionSprite
extends PhetPNode
implements Comparable {
    private Point3D position;
    protected LandscapeNode landscapeNode;
    private List<Listener> listeners;

    public NaturalSelectionSprite(LandscapeNode landscapeNode, Point3D point3D) {
        this.landscapeNode = landscapeNode;
        this.position = point3D;
        this.listeners = new LinkedList<Listener>();
    }

    public Point3D getPosition() {
        return this.position;
    }

    public void setPosition(Point3D point3D) {
        double d = this.position.getZ();
        this.position = point3D;
        this.notifyMoved(d != point3D.getZ());
    }

    public int compareTo(Object object) {
        NaturalSelectionSprite naturalSelectionSprite = (NaturalSelectionSprite)object;
        if (this.position.getZ() == naturalSelectionSprite.getPosition().getZ()) {
            return 0;
        }
        if (this.position.getZ() > naturalSelectionSprite.getPosition().getZ()) {
            return -1;
        }
        return 1;
    }

    public void addSpriteListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeSpriteListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyMoved(boolean bl) {
        for (Listener listener : this.listeners) {
            listener.spriteMoved(this, bl);
        }
    }

    public static interface Listener {
        public void spriteMoved(NaturalSelectionSprite var1, boolean var2);
    }
}

