/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.MotionResources;
import edu.colorado.phet.common.motion.charts.TemporalChart;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.AbstractMediaButton;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ChartZoomControlNode
extends PNode {
    private VerticalZoomControl verticalZoomControl;
    private HorizontalZoomControl horizontalZoomControl;

    public ChartZoomControlNode(final TemporalChart temporalChart) {
        this.horizontalZoomControl = new HorizontalZoomControl(temporalChart);
        this.addChild(this.horizontalZoomControl);
        this.verticalZoomControl = new VerticalZoomControl(temporalChart);
        this.addChild(this.verticalZoomControl);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                ChartZoomControlNode.this.horizontalZoomControl.setOffset(0.0, temporalChart.getViewDimension().getHeight() - ChartZoomControlNode.this.horizontalZoomControl.getFullBounds().getHeight());
            }
        };
        temporalChart.getViewDimension().addObserver(simpleObserver);
        simpleObserver.update();
    }

    public void setHorizontalZoomButtonsVisible(boolean bl) {
        this.horizontalZoomControl.setVisible(bl);
        this.horizontalZoomControl.setPickable(bl);
        this.horizontalZoomControl.setChildrenPickable(bl);
    }

    private static class HorizontalZoomControl
    extends PNode {
        private HorizontalZoomControl(final TemporalChart temporalChart) {
            final ZoomButton zoomButton = new ZoomButton("magnify-plus.png", new Listener(){

                public void actionPerformed() {
                    temporalChart.zoomInHorizontal();
                }
            });
            this.addChild(zoomButton);
            final ZoomButton zoomButton2 = new ZoomButton("magnify-minus.png", new Listener(){

                public void actionPerformed() {
                    temporalChart.zoomOutHorizontal();
                }
            });
            this.addChild(zoomButton2);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    zoomButton.setEnabled(temporalChart.getDataModelBounds().getWidth() > temporalChart.getMinimumDomainRange() + 1.0E-6);
                    zoomButton2.setEnabled(temporalChart.getDataModelBounds().getWidth() < temporalChart.getMaximumDomainRange() - 1.0E-6);
                }
            };
            temporalChart.getDataModelBounds().addObserver(simpleObserver);
            simpleObserver.update();
            zoomButton2.setOffset(0.0, 5.0);
            zoomButton.setOffset(zoomButton2.getFullBounds().getMaxX(), 5.0);
            TriangleIcon triangleIcon = new TriangleIcon();
            triangleIcon.setOffset(zoomButton2.getFullBounds().getMaxX() - triangleIcon.getFullBounds().getWidth() - 0.5, 0.0);
            triangleIcon.rotateInPlace(Math.PI);
            this.addChild(triangleIcon);
            TriangleIcon triangleIcon2 = new TriangleIcon();
            triangleIcon2.setOffset(triangleIcon.getFullBounds().getMaxX() + 1.5, 0.0);
            this.addChild(triangleIcon2);
        }
    }

    public static interface Listener {
        public void actionPerformed();
    }

    public static class TriangleIcon
    extends PNode {
        private double triangleHeight = 6.0;
        private double triangleWidth = 6.0;

        public TriangleIcon() {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(this.triangleWidth, this.triangleHeight / 2.0);
            doubleGeneralPath.lineToRelative(-this.triangleWidth, -this.triangleHeight / 2.0);
            doubleGeneralPath.lineToRelative(0.0, this.triangleHeight);
            doubleGeneralPath.lineTo(this.triangleWidth, this.triangleHeight / 2.0);
            GeneralPath generalPath = doubleGeneralPath.getGeneralPath();
            this.addChild(new PhetPPath((Shape)generalPath, (Paint)Color.black));
        }
    }

    private static class VerticalZoomControl
    extends PNode {
        private VerticalZoomControl(final TemporalChart temporalChart) {
            final ZoomButton zoomButton = new ZoomButton("magnify-plus.png", new Listener(){

                public void actionPerformed() {
                    temporalChart.zoomInVertical();
                }
            });
            final ZoomButton zoomButton2 = new ZoomButton("magnify-minus.png", new Listener(){

                public void actionPerformed() {
                    temporalChart.zoomOutVertical();
                }
            });
            this.addChild(zoomButton2);
            temporalChart.getDataModelBounds().addObserver(new SimpleObserver(){

                public void update() {
                    zoomButton.setEnabled(temporalChart.getDataModelBounds().getHeight() > temporalChart.getMinimumRangeRange() + 1.0E-6);
                    zoomButton2.setEnabled(temporalChart.getDataModelBounds().getHeight() < temporalChart.getMaximumRangeRange() - 1.0E-6);
                }
            });
            this.addChild(zoomButton);
            TriangleIcon triangleIcon = new TriangleIcon();
            triangleIcon.setOffset(1.5, zoomButton.getFullBounds().getHeight() - triangleIcon.getFullBounds().getHeight() - 0.75);
            triangleIcon.rotateInPlace(4.71238898038469);
            this.addChild(triangleIcon);
            TriangleIcon triangleIcon2 = new TriangleIcon();
            triangleIcon2.setOffset(1.5, triangleIcon2.getFullBounds().getHeight() + 1.5 + zoomButton.getFullBounds().getHeight() - triangleIcon.getFullBounds().getHeight() - 0.75);
            triangleIcon2.rotateInPlace(1.5707963267948966);
            this.addChild(triangleIcon2);
            zoomButton.setOffset(triangleIcon2.getFullBounds().getWidth() + 3.0, 0.0);
            zoomButton2.setOffset(triangleIcon2.getFullBounds().getWidth() + 3.0, zoomButton.getFullBounds().getHeight());
        }
    }

    private static class ZoomButton
    extends PNode {
        protected AbstractMediaButton button;

        private ZoomButton(final String string, final Listener listener) {
            this.button = new AbstractMediaButton(30){

                protected BufferedImage createImage() {
                    try {
                        return BufferedImageUtils.multiScaleToHeight(MotionResources.loadBufferedImage(string), 30);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new RuntimeException(iOException);
                    }
                }
            };
            ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
            this.button.addInputEventListener(buttonEventHandler);
            buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventAdapter(){

                public void fire() {
                    if (ZoomButton.this.button.isEnabled()) {
                        listener.actionPerformed();
                    }
                }
            });
            this.addChild(this.button);
        }

        public void setEnabled(boolean bl) {
            this.button.setEnabled(bl);
        }
    }
}

