/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.charts.MotionSliderNode;
import edu.colorado.phet.common.motion.charts.Range;
import edu.colorado.phet.common.motion.charts.TemporalChart;
import edu.colorado.phet.common.motion.tests.ColorArrows;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TemporalChartSliderNode
extends MotionSliderNode.Vertical {
    private final TemporalChart temporalChart;

    public TemporalChartSliderNode(TemporalChart temporalChart, Color color) {
        this(temporalChart, new PImage(ColorArrows.createArrow(color)), color);
    }

    public TemporalChartSliderNode(final TemporalChart temporalChart, PNode pNode, Color color) {
        super(new Range(temporalChart.getMinRangeValue(), temporalChart.getMaxRangeValue()), 0.0, new Range(0.0, 100.0), pNode, color);
        this.temporalChart = temporalChart;
        final SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                TemporalChartSliderNode.this.setViewRange(0.0, temporalChart.getViewDimension().getHeight());
            }
        };
        temporalChart.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                simpleObserver.update();
            }
        });
        simpleObserver.update();
        temporalChart.getDataModelBounds().addObserver(new SimpleObserver(){

            public void update() {
                TemporalChartSliderNode.this.setModelRange(temporalChart.getMinRangeValue(), temporalChart.getMaxRangeValue());
            }
        });
    }
}

