/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.model.TimeData;
import java.util.ArrayList;
import java.util.Arrays;

public class TemporalDataSeries {
    private ArrayList<TimeData> data = new ArrayList();
    private ArrayList<Listener> listeners = new ArrayList();
    private boolean visible = true;

    public TimeData[] getData() {
        return this.data.toArray(new TimeData[this.data.size()]);
    }

    public void addPoint(double d, double d2) {
        this.addPoint(new TimeData(d, d2));
    }

    public void addPoint(TimeData timeData) {
        this.data.add(timeData);
        for (Listener listener : this.listeners) {
            listener.dataPointAdded(timeData);
        }
    }

    private void notifyEntrireSeriesChanged() {
        for (Listener listener : this.listeners) {
            listener.entireSeriesChanged();
        }
    }

    public int getNumPoints() {
        return this.data.size();
    }

    public TimeData getDataPoint(int n) {
        return this.data.get(n);
    }

    public void setData(TimeData[] timeDataArray) {
        this.data.clear();
        this.data.addAll(Arrays.asList(timeDataArray));
        this.notifyEntrireSeriesChanged();
    }

    public TimeData[] getPointsInRange(int n, int n2) {
        ArrayList<TimeData> arrayList = new ArrayList<TimeData>();
        int n3 = this.getNumPoints();
        for (int i = n; i <= n2; ++i) {
            if (i < 0 || i >= n3) continue;
            arrayList.add(this.data.get(i));
        }
        return arrayList.toArray(new TimeData[arrayList.size()]);
    }

    public void clear() {
        this.data.clear();
        this.notifyEntrireSeriesChanged();
    }

    public TimeData getLastPoint() {
        return this.data.get(this.getNumPoints() - 1);
    }

    public TimeData getMidPoint() {
        return this.data.get(this.getNumPoints() / 2);
    }

    public void clearPointsAfter(double d) {
        ArrayList<TimeData> arrayList = new ArrayList<TimeData>();
        for (TimeData timeData : this.data) {
            if (!(timeData.getTime() < d)) continue;
            arrayList.add(timeData);
        }
        this.data.clear();
        this.data.addAll(arrayList);
        this.notifyEntrireSeriesChanged();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void removePoint(int n) {
        this.data.remove(n);
        this.notifyEntrireSeriesChanged();
    }

    public static class Adapter
    implements Listener {
        public void entireSeriesChanged() {
        }

        public void dataPointAdded(TimeData timeData) {
        }

        public void visibilityChanged() {
        }
    }

    public static class LimitedSize
    extends TemporalDataSeries {
        private int maxSize;

        public LimitedSize(int n) {
            this.maxSize = n;
        }

        public void addPoint(double d, double d2) {
            super.addPoint(d, d2);
            while (this.getNumPoints() > this.maxSize) {
                ((TemporalDataSeries)this).removePoint(0);
            }
        }
    }

    public static class LimitedTime
    extends TemporalDataSeries {
        private double maxTime;

        public LimitedTime(double d) {
            this.maxTime = d;
        }

        public void addPoint(double d, double d2) {
            super.addPoint(d, d2);
            if (d2 <= this.maxTime) {
                super.addPoint(d, d2);
            }
        }
    }

    public static interface Listener {
        public void entireSeriesChanged();

        public void dataPointAdded(TimeData var1);
    }
}

