/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import java.util.ArrayList;

class ModuleManager {
    private ArrayList<Module> modules = new ArrayList();
    private Module activeModule;
    private PhetApplication phetApplication;
    private ArrayList moduleObservers = new ArrayList();
    private Module startModule;

    ModuleManager(PhetApplication phetApplication) {
        this.phetApplication = phetApplication;
        this.startModule = null;
    }

    Module moduleAt(int n) {
        return this.modules.get(n);
    }

    Module getActiveModule() {
        return this.activeModule;
    }

    int numModules() {
        return this.modules.size();
    }

    void addModule(Module module) {
        if (this.modules.size() == 0) {
            this.startModule = module;
        }
        this.modules.add(module);
        this.notifyModuleAdded(new ModuleEvent(this.getPhetApplication(), module));
    }

    void removeModule(Module module) {
        this.modules.remove(module);
        if (module == this.startModule) {
            this.startModule = null;
            if (this.modules.size() > 0) {
                this.startModule = this.moduleAt(0);
            }
        }
        if (this.getActiveModule() == module) {
            this.setActiveModule(this.modules.size() == 0 ? null : this.modules.get(0));
        }
        this.notifyModuleRemoved(new ModuleEvent(this.getPhetApplication(), module));
    }

    int indexOf(Module module) {
        return this.modules.indexOf(module);
    }

    void setModules(Module[] moduleArray) {
        while (this.numModules() > 0) {
            Module module = this.moduleAt(0);
            this.removeModule(module);
        }
        this.addAllModules(moduleArray);
    }

    void addAllModules(Module[] moduleArray) {
        for (int i = 0; i < moduleArray.length; ++i) {
            this.addModule(moduleArray[i]);
        }
    }

    Module[] getModules() {
        Module[] moduleArray = new Module[this.modules.size()];
        for (int i = 0; i < this.modules.size(); ++i) {
            moduleArray[i] = this.modules.get(i);
        }
        return moduleArray;
    }

    void setActiveModule(int n) {
        this.setActiveModule(this.moduleAt(n));
    }

    void setActiveModule(Module module) {
        if (module == null) {
            throw new RuntimeException("Active module can't be null.");
        }
        if (this.activeModule != module) {
            this.deactivateCurrentModule();
            this.activate(module);
            this.notifyActiveModuleChanged(new ModuleEvent(this.getPhetApplication(), module));
            this.verifyActiveState();
        }
    }

    private void verifyActiveState() {
        int n = this.getNumActiveModules();
        int n2 = this.getNumClocksRunning();
        boolean bl = this.isClockShared();
        if (n != 1) {
            new IllegalStateException("multiple modules are running: active modules=" + n).printStackTrace();
        }
        if (n2 > 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Module module : this.modules) {
                if (!module.getClock().isRunning()) continue;
                arrayList.add(module.getName());
            }
            new IllegalStateException("multiple clocks are running: running clocks=" + n2 + ", in modules " + arrayList).printStackTrace();
        }
        if (n2 == 1 && !this.activeModule.getClock().isRunning()) {
            new IllegalStateException("a clock is running that does not belong to the active module").printStackTrace();
        }
        if (bl) {
            new IllegalStateException("Multiple modules are using the same clock instance.").printStackTrace();
        }
    }

    private boolean isClockShared() {
        for (int i = 0; i < this.modules.size(); ++i) {
            for (int j = 0; j < this.modules.size(); ++j) {
                IClock iClock;
                IClock iClock2;
                if (j == i || (iClock2 = this.modules.get(i).getClock()) != (iClock = this.modules.get(j).getClock())) continue;
                return true;
            }
        }
        return false;
    }

    private int getNumActiveModules() {
        int n = 0;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!this.modules.get(i).isActive()) continue;
            ++n;
        }
        return n;
    }

    private int getNumClocksRunning() {
        ArrayList<IClock> arrayList = new ArrayList<IClock>();
        for (int i = 0; i < this.modules.size(); ++i) {
            IClock iClock = this.modules.get(i).getClock();
            if (!iClock.isRunning() || arrayList.contains(iClock)) continue;
            arrayList.add(iClock);
        }
        return arrayList.size();
    }

    void addModuleObserver(ModuleObserver moduleObserver) {
        this.moduleObservers.add(moduleObserver);
    }

    private PhetApplication getPhetApplication() {
        return this.phetApplication;
    }

    private void activate(Module module) {
        this.activeModule = module;
        if (module != null) {
            module.activate();
            this.setActiveModule(module);
        }
    }

    void deactivateCurrentModule() {
        if (this.activeModule != null) {
            this.activeModule.deactivate();
        }
    }

    private void notifyModuleAdded(ModuleEvent moduleEvent) {
        for (int i = 0; i < this.moduleObservers.size(); ++i) {
            ModuleObserver moduleObserver = (ModuleObserver)this.moduleObservers.get(i);
            moduleObserver.moduleAdded(moduleEvent);
        }
    }

    private void notifyActiveModuleChanged(ModuleEvent moduleEvent) {
        for (int i = 0; i < this.moduleObservers.size(); ++i) {
            ModuleObserver moduleObserver = (ModuleObserver)this.moduleObservers.get(i);
            moduleObserver.activeModuleChanged(moduleEvent);
        }
    }

    private void notifyModuleRemoved(ModuleEvent moduleEvent) {
        for (int i = 0; i < this.moduleObservers.size(); ++i) {
            ModuleObserver moduleObserver = (ModuleObserver)this.moduleObservers.get(i);
            moduleObserver.moduleRemoved(moduleEvent);
        }
    }

    public Module getStartModule() {
        return this.startModule;
    }

    public void setStartModule(Module module) {
        if (!this.modules.contains(module)) {
            throw new IllegalArgumentException("start module has not been added");
        }
        this.startModule = module;
    }

    void removeModuleObserver(ModuleObserver moduleObserver) {
        this.moduleObservers.remove(moduleObserver);
    }
}

