/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.motion.charts.Range;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.movingman.MovingManStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class PlayAreaRulerNode
extends PNode {
    private final PhetPPath face;
    private final PhetPPath base;
    private final PhetPPath side;
    private Range modelRange;
    private Range viewRange;
    private PNode tickLayer;

    public PlayAreaRulerNode(Range range, Range range2) {
        this.modelRange = range;
        this.viewRange = range2;
        this.face = new PhetPPath(new Color(229, 221, 127), (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
        this.base = new PhetPPath(new Color(181, 174, 98), (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
        this.side = new PhetPPath(new Color(173, 165, 80), (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
        range2.addObserver(new SimpleObserver(){

            public void update() {
                PlayAreaRulerNode.this.updateShape();
            }
        });
        this.tickLayer = new PNode();
        this.updateShape();
        this.addChild(this.face);
        this.addChild(this.base);
        this.addChild(this.side);
        this.addChild(this.tickLayer);
    }

    private void updateShape() {
        int n = 20;
        int n2 = 12;
        double d = Math.abs(this.viewRange.getMax() - this.viewRange.getMin()) + (double)(n2 * 2);
        double d2 = this.viewRange.getMin() < this.viewRange.getMax() ? this.viewRange.getMin() - (double)n2 : this.viewRange.getMin() + (double)n2 - d;
        this.face.setPathTo(new Rectangle2D.Double(d2, 0.0, d, n));
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(d2, n);
        doubleGeneralPath.lineToRelative(d, 0.0);
        doubleGeneralPath.lineToRelative(3.0, 3.0);
        doubleGeneralPath.lineToRelative(-d, 0.0);
        doubleGeneralPath.lineTo(d2, n);
        this.base.setPathTo(doubleGeneralPath.getGeneralPath());
        DoubleGeneralPath doubleGeneralPath2 = new DoubleGeneralPath(d2 + d, 0.0);
        doubleGeneralPath2.lineToRelative(3.0, 3.0);
        doubleGeneralPath2.lineToRelative(0.0, n);
        doubleGeneralPath2.lineToRelative(-3.0, -3.0);
        doubleGeneralPath2.lineTo(d2 + d, 0.0);
        this.side.setPathTo(doubleGeneralPath2.getGeneralPath());
        this.tickLayer.removeAllChildren();
        Function.LinearFunction linearFunction = new Function.LinearFunction(this.modelRange.getMin(), this.modelRange.getMax(), this.viewRange.getMin(), this.viewRange.getMax());
        for (double d3 = this.modelRange.getMin(); d3 <= this.modelRange.getMax() + 1.0E-6; d3 += 1.0) {
            TickMark tickMark;
            double d4 = linearFunction.evaluate(d3);
            if (d3 % 2.0 == 0.0) {
                LabeledTickMark labeledTickMark = new LabeledTickMark(4, d3);
                if (d3 == 0.0) {
                    labeledTickMark.setTickText(MovingManStrings.LABEL_ZERO_METERS);
                }
                tickMark = labeledTickMark;
            } else {
                tickMark = new TickMark(7);
            }
            tickMark.setOffset(d4, 0.0);
            this.tickLayer.addChild(tickMark);
        }
    }

    public static class LabeledTickMark
    extends TickMark {
        private PText text;

        public LabeledTickMark(int n, double d) {
            super(n);
            this.text = new PText(new DecimalFormat("0").format(d));
            this.text.setFont(new PhetFont(14, true));
            this.addChild(this.text);
            this.text.setOffset(((TickMark)this).tick.getFullBounds().getCenterX() - this.text.getFullBounds().getWidth() / 2.0, ((TickMark)this).tick.getFullBounds().getHeight());
        }

        public void setTickText(String string) {
            this.text.setText(string);
        }
    }

    public static class TickMark
    extends PNode {
        private final PhetPPath tick;

        public TickMark(int n) {
            double d = 1.0;
            this.tick = new PhetPPath((Shape)new Rectangle2D.Double(-d / 2.0, 0.0, d, n), (Paint)Color.black);
            this.addChild(this.tick);
        }
    }
}

