/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.motion.charts.TextBox;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.movingman.model.MovingMan;
import edu.colorado.phet.movingman.model.MovingManModel;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

public interface TextBoxListener {
    public static final DefaultDecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");

    public void addListeners(TextBox var1);

    public static class Acceleration
    implements TextBoxListener {
        private final MovingManModel model;

        public Acceleration(MovingManModel movingManModel) {
            this.model = movingManModel;
        }

        public void addListeners(final TextBox textBox) {
            MovingMan.Listener listener = new MovingMan.Listener(){

                public void changed() {
                    textBox.setText(decimalFormat.format(Acceleration.this.model.getMovingMan().getAcceleration()));
                }
            };
            this.model.getMovingMan().addListener(listener);
            listener.changed();
            textBox.addListener(new TextBox.Listener(){

                public void changed() {
                    String string = textBox.getText();
                    Acceleration.this.model.getMovingMan().setAccelerationDriven();
                    Acceleration.this.model.getMovingMan().setAcceleration(Double.parseDouble(string));
                }
            });
            textBox.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Acceleration.this.model.getMovingMan().setAccelerationDriven();
                }
            });
        }
    }

    public static class Position
    implements TextBoxListener {
        MovingManModel model;

        public Position(MovingManModel movingManModel) {
            this.model = movingManModel;
        }

        public void addListeners(final TextBox textBox) {
            MovingMan.Listener listener = new MovingMan.Listener(){

                public void changed() {
                    textBox.setText(decimalFormat.format(Position.this.model.getMovingMan().getPosition()));
                }
            };
            listener.changed();
            this.model.getMovingMan().addListener(listener);
            textBox.addListener(new TextBox.Listener(){

                public void changed() {
                    String string = textBox.getText();
                    Position.this.model.getMovingMan().setPositionDriven();
                    Position.this.model.setMousePosition(Double.parseDouble(string));
                }
            });
            textBox.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Position.this.model.getMovingMan().setPositionDriven();
                }
            });
        }
    }

    public static class Velocity
    implements TextBoxListener {
        private final MovingManModel model;

        public Velocity(MovingManModel movingManModel) {
            this.model = movingManModel;
        }

        public void addListeners(final TextBox textBox) {
            MovingMan.Listener listener = new MovingMan.Listener(){

                public void changed() {
                    textBox.setText(decimalFormat.format(Velocity.this.model.getMovingMan().getVelocity()));
                }
            };
            this.model.getMovingMan().addListener(listener);
            listener.changed();
            textBox.addListener(new TextBox.Listener(){

                public void changed() {
                    String string = textBox.getText();
                    Velocity.this.model.getMovingMan().setVelocityDriven();
                    Velocity.this.model.getMovingMan().setVelocity(Double.parseDouble(string));
                }
            });
            textBox.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Velocity.this.model.getMovingMan().setVelocityDriven();
                }
            });
        }
    }
}

