/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.recordandplayback.gui;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineNode<T>
extends PNode {
    private RecordAndPlaybackModel<T> model;
    private PhetPCanvas canvas;
    private double maxTime;
    private int pathOffsetY = 4;
    private int pathHeight = 6;
    private int insetX = 10;
    private PhetPPath shaded;
    private PhetPPath background;
    private PImage handle;

    public TimelineNode(final RecordAndPlaybackModel<T> recordAndPlaybackModel, PhetPCanvas phetPCanvas, Color color, double d) {
        this.model = recordAndPlaybackModel;
        this.canvas = phetPCanvas;
        this.maxTime = d;
        this.shaded = new PhetPPath(color);
        Color color2 = new Color(190, 195, 195);
        this.background = new Track(color2);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageLoader.loadBufferedImage("piccolo-phet/images/button-template.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BufferedImage bufferedImage2 = BufferedImageUtils.getScaledInstance(bufferedImage, 20, 10, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        this.handle = new PImage(bufferedImage2);
        this.addChild(this.background);
        this.addChild(this.shaded);
        this.addChild(this.handle);
        phetPCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TimelineNode.this.updateSelf();
            }
        });
        this.handle.addInputEventListener(new CursorHandler());
        this.handle.addInputEventListener(new PBasicInputEventHandler(){
            double relativeGrabPoint = Double.NaN;

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                if (Double.isNaN(this.relativeGrabPoint)) {
                    this.updateRelativeGrabLocation(pInputEvent);
                }
                recordAndPlaybackModel.setTime(MathUtil.clamp(recordAndPlaybackModel.getMinRecordedTime(), this.getModelPoint(pInputEvent) - this.relativeGrabPoint, recordAndPlaybackModel.getMaxRecordedTime()));
            }

            private void updateRelativeGrabLocation(PInputEvent pInputEvent) {
                this.relativeGrabPoint = this.getModelPoint(pInputEvent) - recordAndPlaybackModel.getTime();
            }

            private double getModelPoint(PInputEvent pInputEvent) {
                return TimelineNode.this.xToTime(pInputEvent.getCanvasPosition().getX());
            }

            public void mousePressed(PInputEvent pInputEvent) {
                super.mousePressed(pInputEvent);
                this.updateRelativeGrabLocation(pInputEvent);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
                this.relativeGrabPoint = Double.NaN;
            }
        });
        this.shaded.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                double d = TimelineNode.this.xToTime(pInputEvent.getCanvasPosition().getX());
                recordAndPlaybackModel.setTime(MathUtil.clamp(recordAndPlaybackModel.getMinRecordedTime(), d, recordAndPlaybackModel.getMaxRecordedTime()));
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                recordAndPlaybackModel.setPaused(true);
                double d = pInputEvent.getCanvasDelta().width;
                recordAndPlaybackModel.setTime(MathUtil.clamp(recordAndPlaybackModel.getMinRecordedTime(), recordAndPlaybackModel.getTime() + TimelineNode.this.deltaXtoDeltaTime(d), recordAndPlaybackModel.getMaxRecordedTime()));
            }
        });
        recordAndPlaybackModel.addObserver(new SimpleObserver(){

            public void update() {
                TimelineNode.this.updateSelf();
            }
        });
        this.updateSelf();
    }

    private static Color darker(Color color, int n) {
        return new Color(color.getRed() - n, color.getGreen() - n, color.getBlue() - n);
    }

    private double deltaXtoDeltaTime(double d) {
        return this.xToTime(d) - this.xToTime(0.0);
    }

    private double timeToX(double d) {
        double d2 = (double)(this.canvas.getWidth() - this.insetX * 2) / this.maxTime;
        return d * d2;
    }

    private double xToTime(double d) {
        double d2 = (double)(this.canvas.getWidth() - this.insetX * 2) / this.maxTime;
        return d / d2;
    }

    private void updateSelf() {
        this.shaded.setPathTo(new Rectangle2D.Double(this.insetX, this.pathOffsetY + 1, this.timeToX(this.model.getRecordedTimeRange()), this.pathHeight - 1));
        this.background.setPathTo(new Rectangle2D.Double(this.insetX, this.pathOffsetY, this.timeToX(this.maxTime), this.pathHeight));
        this.handle.setVisible(this.model.isPlayback());
        double d = this.model.getTime() - this.model.getMinRecordedTime();
        this.handle.setOffset(this.timeToX(d) - this.handle.getFullBounds().getWidth() / 2.0 + (double)this.insetX, this.pathOffsetY - 2);
    }

    public static class Track
    extends PhetPPath {
        private PhetPPath topShade;
        private PhetPPath bottomShade;
        private PhetPPath leftShade;
        private PhetPPath rightShade;

        public Track(Color color) {
            super(color);
            this.topShade = new PhetPPath(new BasicStroke(2.0f), (Paint)TimelineNode.darker(color, 55));
            this.addChild(this.topShade);
            this.bottomShade = new PhetPPath(new BasicStroke(1.0f), (Paint)TimelineNode.darker(color, 20));
            this.addChild(this.bottomShade);
            this.leftShade = new PhetPPath(new BasicStroke(2.0f), (Paint)TimelineNode.darker(color, 50));
            this.addChild(this.leftShade);
            this.rightShade = new PhetPPath(new BasicStroke(1.0f), (Paint)TimelineNode.darker(color, 20));
            this.addChild(this.rightShade);
        }

        public void setPathTo(Shape shape) {
            super.setPathTo(shape);
            Rectangle2D rectangle2D = shape.getBounds2D();
            this.topShade.setPathTo(new Line2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getMaxX(), rectangle2D.getY()));
            this.bottomShade.setPathTo(new Line2D.Double(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()));
            this.leftShade.setPathTo(new Line2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX(), rectangle2D.getMaxY()));
            this.rightShade.setPathTo(new Line2D.Double(rectangle2D.getMaxX(), rectangle2D.getY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()));
        }
    }
}

