/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import org.bson.BSONObject;

public class ServerError {
    final String _err;
    final int _code;

    ServerError(DBObject o) {
        this._err = ServerError.getMsg(o, null);
        if (this._err == null) {
            throw new IllegalArgumentException("need to have $err");
        }
        this._code = ServerError.getCode(o);
    }

    static String getMsg(BSONObject o, String def) {
        Object e = o.get("$err");
        if (e == null) {
            e = o.get("err");
        }
        if (e == null) {
            e = o.get("errmsg");
        }
        if (e == null) {
            return def;
        }
        return e.toString();
    }

    static int getCode(BSONObject o) {
        Object c = o.get("code");
        if (c == null) {
            c = o.get("$code");
        }
        if (c == null) {
            c = o.get("assertionCode");
        }
        if (c == null) {
            return -5;
        }
        return ((Number)c).intValue();
    }

    public boolean isNotMasterError() {
        switch (this._code) {
            case 10054: 
            case 10056: 
            case 10058: 
            case 10107: 
            case 13435: 
            case 13436: {
                return true;
            }
        }
        return this._err.startsWith("not master");
    }

    public String toString() {
        if (this._code > 0) {
            return this._code + " " + this._err;
        }
        return this._err;
    }
}

