/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.charts.ChartCursor;
import edu.colorado.phet.common.motion.charts.HighQualityPhetPPath;
import edu.colorado.phet.common.motion.charts.TemporalChart;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CursorNode
extends PClip {
    private ChartCursor cursor;
    private TemporalChart chart;
    private PhetPPath path;

    public CursorNode(final ChartCursor chartCursor, final TemporalChart temporalChart) {
        this.cursor = chartCursor;
        this.chart = temporalChart;
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                Point2D point2D = temporalChart.modelToView(new TimeData(temporalChart.getDataModelBounds().getMaxY(), temporalChart.getDataModelBounds().getMinX()));
                Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), temporalChart.getViewDimension().getWidth(), temporalChart.getViewDimension().getHeight());
                CursorNode.this.setPathTo(double_);
            }
        };
        temporalChart.getViewDimension().addObserver(simpleObserver);
        simpleObserver.update();
        this.path = new HighQualityPhetPPath(new Color(50, 50, 200, 83), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f, 2.0f}, 0.0f), new Color(20, 20, 30, 160));
        this.addChild(this.path);
        final ChartCursor.Adapter adapter = new ChartCursor.Adapter(){

            public void positionChanged() {
                double d = chartCursor.getTime();
                double d2 = temporalChart.modelToView(new TimeData(0.0, d)).getX();
                double d3 = 6.0;
                CursorNode.this.path.setPathTo(new Rectangle2D.Double(d2 - d3 / 2.0, 0.0, d3, temporalChart.getViewDimension().getHeight()));
            }
        };
        adapter.positionChanged();
        temporalChart.getViewDimension().addObserver(new SimpleObserver(){

            public void update() {
                adapter.positionChanged();
            }
        });
        chartCursor.addListener(adapter);
        temporalChart.getDataModelBounds().addObserver(new SimpleObserver(){

            public void update() {
                adapter.positionChanged();
            }
        });
        ChartCursor.Adapter adapter2 = new ChartCursor.Adapter(){

            public void visibilityChanged() {
                CursorNode.this.setVisible(chartCursor.isVisible());
            }
        };
        adapter2.visibilityChanged();
        chartCursor.addListener(adapter2);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){
            double relativeGrabPoint = Double.NaN;

            public void mousePressed(PInputEvent pInputEvent) {
                super.mousePressed(pInputEvent);
                this.updateRelativeGrabPoint(pInputEvent);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                if (Double.isNaN(this.relativeGrabPoint)) {
                    this.updateRelativeGrabPoint(pInputEvent);
                }
                chartCursor.setTime(this.getModelPoint(pInputEvent) - this.relativeGrabPoint);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
                this.relativeGrabPoint = Double.NaN;
            }

            private void updateRelativeGrabPoint(PInputEvent pInputEvent) {
                this.relativeGrabPoint = this.getModelPoint(pInputEvent) - chartCursor.getTime();
            }

            private double getModelPoint(PInputEvent pInputEvent) {
                return temporalChart.viewToModel(pInputEvent.getPositionRelativeTo(temporalChart).getX());
            }
        });
    }
}

