/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.charts.ControlChartLayout;
import edu.colorado.phet.common.motion.charts.MinimizableControlChart;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class MultiControlChart
extends PNode {
    private ArrayList<MinimizableControlChart> children = new ArrayList();
    private double width;
    private double height;

    public MultiControlChart(final MinimizableControlChart[] minimizableControlChartArray) {
        for (MinimizableControlChart minimizableControlChart : minimizableControlChartArray) {
            this.children.add(minimizableControlChart);
            this.addChild(minimizableControlChart);
            minimizableControlChart.getMaximized().addObserver(new SimpleObserver(){

                public void update() {
                    MultiControlChart.this.updateLayout();
                }
            });
        }
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                for (int i = minimizableControlChartArray.length - 1; i >= 0; --i) {
                    if (!((Boolean)minimizableControlChartArray[i].getMaximized().get()).booleanValue()) continue;
                    MultiControlChart.this.setHorizontalZoomButtonVisible(i);
                    break;
                }
            }
        };
        for (MinimizableControlChart minimizableControlChart : minimizableControlChartArray) {
            minimizableControlChart.getMaximized().addObserver(simpleObserver);
        }
        simpleObserver.update();
        SimpleObserver simpleObserver2 = new SimpleObserver(){

            public void update() {
                for (int i = minimizableControlChartArray.length - 1; i >= 0; --i) {
                    if (!((Boolean)minimizableControlChartArray[i].getMaximized().get()).booleanValue()) continue;
                    MultiControlChart.this.setDomainAxisLabelsVisible(i);
                    break;
                }
            }
        };
        for (final MinimizableControlChart minimizableControlChart : minimizableControlChartArray) {
            minimizableControlChart.getMaximized().addObserver(simpleObserver2);
        }
        simpleObserver2.update();
        for (final MinimizableControlChart minimizableControlChart : minimizableControlChartArray) {
            minimizableControlChart.getChartNode().getDataModelBounds().addObserver(new SimpleObserver(){

                public void update() {
                    for (MinimizableControlChart minimizableControlChart2 : minimizableControlChartArray) {
                        minimizableControlChart2.getChartNode().getDataModelBounds().setHorizontalRange(minimizableControlChart.getChartNode().getDataModelBounds().getMinX(), minimizableControlChart.getChartNode().getDataModelBounds().getMaxX());
                    }
                }
            });
        }
    }

    private void setDomainAxisLabelsVisible(int n) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).setDomainAxisLabelsVisible(i == n);
        }
    }

    private void updateLayout() {
        new ControlChartLayout.AlignedLayout().updateLayout(this.children.toArray(new MinimizableControlChart[0]), this.width, this.height);
    }

    private void setHorizontalZoomButtonVisible(int n) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).setHorizontalZoomVisible(n == i);
        }
    }

    public void setSize(double d, double d2) {
        this.width = d;
        this.height = d2;
        this.updateLayout();
    }

    public boolean setBounds(double d, double d2, double d3, double d4) {
        this.setSize(d3, d4);
        this.setOffset(d, d2);
        return true;
    }
}

