/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.tests;

import edu.colorado.phet.common.motion.MotionResources;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.io.IOException;

public class ColorArrows {
    public static BufferedImage filter(BufferedImage bufferedImage, Color color) {
        LookupOp lookupOp = new LookupOp(new Table(color), null);
        return lookupOp.filter(bufferedImage, null);
    }

    public static BufferedImage createArrow(Color color) {
        try {
            return ColorArrows.filter(MotionResources.loadBufferedImage("arrow-template.png"), color);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    private static class Table
    extends LookupTable {
        private int[] replacement;
        private int[] template = new int[]{79, 140, 232, 255};

        public Table(Color color) {
            super(0, 4);
            this.replacement = new int[]{color.getRed(), color.getGreen(), color.getBlue(), 255};
        }

        public int[] lookupPixel(int[] nArray, int[] nArray2) {
            System.arraycopy(this.getReplacement(nArray), 0, nArray2, 0, nArray2.length);
            return nArray2;
        }

        private int[] getReplacement(int[] nArray) {
            int[] nArray2 = this.diffRGB(nArray, this.template);
            int n = nArray2[0] + nArray2[1] + nArray2[2];
            int[] nArray3 = new int[]{this.replacement[0] + n, this.replacement[1] + n, this.replacement[2] + n, nArray[3]};
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = Math.min(nArray3[i], 255);
                nArray3[i] = Math.max(nArray3[i], 0);
            }
            return nArray3;
        }

        private int[] diffRGB(int[] nArray, int[] nArray2) {
            int[] nArray3 = new int[3];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = nArray[i] - nArray2[i];
            }
            return nArray3;
        }
    }
}

