/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.help;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.help.AbstractHelpItem;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class HelpBalloon
extends AbstractHelpItem {
    public static final Attachment TOP_LEFT = new Attachment("top left");
    public static final Attachment TOP_CENTER = new Attachment("top center");
    public static final Attachment TOP_RIGHT = new Attachment("top right");
    public static final Attachment BOTTOM_LEFT = new Attachment("bottom left");
    public static final Attachment BOTTOM_CENTER = new Attachment("bottom center");
    public static final Attachment BOTTOM_RIGHT = new Attachment("bottom right");
    public static final Attachment LEFT_TOP = new Attachment("left top");
    public static final Attachment LEFT_CENTER = new Attachment("left center");
    public static final Attachment LEFT_BOTTOM = new Attachment("left bottom");
    public static final Attachment RIGHT_TOP = new Attachment("right top");
    public static final Attachment RIGHT_CENTER = new Attachment("right center");
    public static final Attachment RIGHT_BOTTOM = new Attachment("right bottom");
    private static final Font DEFAULT_TEXT_FONT = new PhetFont(0, 14);
    private static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private static final Dimension DEFAULT_SHADOW_TEXT_OFFSET = new Dimension(1, 1);
    private static final Color DEFAULT_SHADOW_TEXT_COLOR = Color.RED;
    private static final Paint DEFAULT_ARROW_FILL_PAINT = new Color(250, 250, 170, 175);
    private static final Paint DEFAULT_ARROW_BORDER_PAINT = Color.BLACK;
    private static final Stroke DEFAULT_ARROW_STROKE = new BasicStroke(1.0f);
    private static final Paint DEFAULT_BALLOON_FILL_PAINT = DEFAULT_ARROW_FILL_PAINT;
    private static final Paint DEFAULT_BALLOON_BORDER_PAINT = DEFAULT_ARROW_BORDER_PAINT;
    private static final Stroke DEFAULT_BALLOON_STROKE = DEFAULT_ARROW_STROKE;
    private HTMLNode _textNode;
    private HTMLNode _shadowTextNode;
    private PComposite _compositeTextNode;
    private PPath _balloonNode;
    private PPath _arrowNode;
    private Attachment _arrowTailPosition;
    private double _arrowLength;
    private double _arrowRotation;
    private Dimension _arrowHeadSize;
    private double _arrowTailWidth;
    private double _textMargin;
    private Dimension _shadowTextOffset;
    private double _balloonCornerRadius;
    private double _balloonArrowSpacing;
    private boolean _updateEnabled;
    private boolean _arrowVisible = true;

    public HelpBalloon(JComponent jComponent, String string) {
        this(jComponent, string, TOP_LEFT, 0.0, 0.0);
    }

    public HelpBalloon(JComponent jComponent, String string, Attachment attachment, double d) {
        this(jComponent, string, attachment, d, 0.0);
    }

    public HelpBalloon(JComponent jComponent, String string, Attachment attachment, double d, double d2) {
        super(jComponent);
        if (!this.isValidArrowLength(d)) {
            throw new IllegalArgumentException("invalid arrowLength: " + d);
        }
        if (!this.isValidArrowRotation(d2)) {
            throw new IllegalArgumentException("invalid arrowRotation: " + d2);
        }
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._arrowTailPosition = attachment;
        this._arrowLength = d;
        this._arrowRotation = d2;
        this._arrowHeadSize = new Dimension(10, 10);
        this._arrowTailWidth = 3.0;
        this._arrowNode = new PPath();
        this._arrowNode.setPaint(DEFAULT_ARROW_FILL_PAINT);
        this._arrowNode.setStroke(DEFAULT_ARROW_STROKE);
        this._arrowNode.setStrokePaint(DEFAULT_ARROW_BORDER_PAINT);
        this._balloonCornerRadius = 15.0;
        this._balloonArrowSpacing = 0.0;
        this._balloonNode = new PPath();
        this._balloonNode.setPaint(DEFAULT_BALLOON_FILL_PAINT);
        this._balloonNode.setStroke(DEFAULT_BALLOON_STROKE);
        this._balloonNode.setStrokePaint(DEFAULT_BALLOON_BORDER_PAINT);
        this._textMargin = 4.0;
        this._textNode = new HTMLNode(string);
        this._textNode.setFont(DEFAULT_TEXT_FONT);
        this._textNode.setHTMLColor(DEFAULT_TEXT_COLOR);
        this._shadowTextOffset = new Dimension(DEFAULT_SHADOW_TEXT_OFFSET);
        this._shadowTextNode = new HTMLNode(string);
        this._shadowTextNode.setFont(DEFAULT_TEXT_FONT);
        this._shadowTextNode.setHTMLColor(DEFAULT_SHADOW_TEXT_COLOR);
        this._shadowTextNode.setVisible(false);
        this._compositeTextNode = new PComposite();
        this._compositeTextNode.addChild(this._shadowTextNode);
        this._compositeTextNode.addChild(this._textNode);
        this.addChild(this._arrowNode);
        this.addChild(this._balloonNode);
        this.addChild(this._compositeTextNode);
        this._updateEnabled = true;
        this.updateDisplay();
    }

    public String toString() {
        return this.getClass().getName() + " [text=" + this._textNode.getHTML() + "]";
    }

    public void setFont(Font font) {
        this._textNode.setFont(font);
        this._shadowTextNode.setFont(font);
        this.updateDisplay();
    }

    public void setTextColor(Color color) {
        this._textNode.setHTMLColor(color);
    }

    public void setTextMargin(double d) {
        this._textMargin = d;
        this.updateDisplay();
    }

    public void setShadowTextEnabled(boolean bl) {
        this._shadowTextNode.setVisible(bl);
        this.updateDisplay();
    }

    public void setShadowTextColor(Color color) {
        this._shadowTextNode.setHTMLColor(color);
    }

    public void setShadowTextOffset(double d, double d2) {
        this._shadowTextOffset.setSize(d, d2);
        this.updateDisplay();
    }

    public void setShadowTextOffset(double d) {
        this.setShadowTextOffset(d, d);
    }

    public void setBalloonVisible(boolean bl) {
        this._balloonNode.setVisible(bl);
    }

    public void setBalloonFillPaint(Paint paint) {
        this._balloonNode.setPaint(paint);
    }

    public void setBalloonStrokePaint(Paint paint) {
        this._balloonNode.setStrokePaint(paint);
    }

    public void setBalloonStroke(Stroke stroke) {
        this._balloonNode.setStroke(stroke);
    }

    public void setBalloonCornerRadius(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("radius < 0: " + d);
        }
        this._balloonCornerRadius = d;
        this.updateDisplay();
    }

    public void setArrowFillPaint(Paint paint) {
        this._arrowNode.setPaint(paint);
    }

    public void setArrowStrokePaint(Paint paint) {
        this._arrowNode.setStrokePaint(paint);
    }

    public void setArrowStroke(Stroke stroke) {
        this._arrowNode.setStroke(stroke);
    }

    public void setArrowHeadSize(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("width <= 0: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("height <= 0: " + n2);
        }
        this._arrowHeadSize = new Dimension(n, n2);
        this.updateDisplay();
    }

    public void setArrowTailWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("width <= 0: " + d);
        }
        this._arrowTailWidth = d;
        this.updateDisplay();
    }

    public void setArrowBalloonSpacing(double d) {
        this._balloonArrowSpacing = d;
        this.updateDisplay();
    }

    public void setArrowTailPosition(Attachment attachment) {
        this._arrowTailPosition = attachment;
        this.updatePosition();
        this.updateDisplay();
    }

    public void setArrowLength(double d) {
        if (!this.isValidArrowLength(d)) {
            throw new IllegalArgumentException("invlaid arrow length: " + d);
        }
        this._arrowLength = d;
        this.updateDisplay();
    }

    public void setArrowRotation(double d) {
        if (!this.isValidArrowRotation(d)) {
            throw new IllegalArgumentException("invalid arrowRotation: " + d);
        }
        this._arrowRotation = d;
        this.updateDisplay();
    }

    protected boolean isArrowOnTop() {
        return this._arrowTailPosition == TOP_LEFT || this._arrowTailPosition == TOP_CENTER || this._arrowTailPosition == TOP_RIGHT;
    }

    protected boolean isArrowOnBottom() {
        return this._arrowTailPosition == BOTTOM_LEFT || this._arrowTailPosition == BOTTOM_CENTER || this._arrowTailPosition == BOTTOM_RIGHT;
    }

    protected boolean isArrowOnLeft() {
        return this._arrowTailPosition == LEFT_TOP || this._arrowTailPosition == LEFT_CENTER || this._arrowTailPosition == LEFT_BOTTOM;
    }

    protected boolean isArrowOnRight() {
        return this._arrowTailPosition == RIGHT_TOP || this._arrowTailPosition == RIGHT_CENTER || this._arrowTailPosition == RIGHT_BOTTOM;
    }

    public boolean isValidArrowLength(double d) {
        return d >= 0.0;
    }

    public boolean isValidArrowRotation(double d) {
        return d >= -70.0 && d <= 70.0;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.getVisible()) {
            this.updateDisplay();
        }
    }

    public void updateDisplay() {
        if (!this._updateEnabled) {
            return;
        }
        Cloneable cloneable = this._textNode.getBounds();
        if (this._shadowTextNode.getVisible()) {
            cloneable = this._compositeTextNode.getFullBounds();
        }
        double d = ((RectangularShape)cloneable).getWidth() + 2.0 * this._textMargin;
        double d2 = ((RectangularShape)cloneable).getHeight() + 2.0 * this._textMargin;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d, d2, this._balloonCornerRadius, this._balloonCornerRadius);
        this._balloonNode.setPathTo(double_);
        if (this._arrowLength <= this._arrowHeadSize.getHeight()) {
            this._arrowNode.setVisible(false);
        } else {
            this._arrowNode.setVisible(this._arrowVisible);
            cloneable = new Point(0, 0);
            Point point = new Point();
            if (this.isArrowOnTop()) {
                point.setLocation(0.0, this._arrowLength);
            } else if (this.isArrowOnBottom()) {
                point.setLocation(0.0, -this._arrowLength);
            } else if (this.isArrowOnLeft()) {
                point.setLocation(this._arrowLength, 0.0);
            } else if (this.isArrowOnRight()) {
                point.setLocation(-this._arrowLength, 0.0);
            } else {
                throw new IllegalArgumentException("illegal arrow position: " + this._arrowTailPosition);
            }
            Arrow arrow = new Arrow(point, (Point2D)cloneable, this._arrowHeadSize.getHeight(), this._arrowHeadSize.getWidth(), this._arrowTailWidth);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(this._arrowRotation));
            Shape shape = affineTransform.createTransformedShape(arrow.getShape());
            this._arrowNode.setPathTo(shape);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = this._arrowNode.getVisible();
        double d5 = this._arrowHeadSize.getWidth() / 2.0;
        if (this._arrowTailPosition == TOP_LEFT) {
            if (!bl) {
                d3 = 0.0;
                d4 = 0.0;
            } else {
                d3 = -(this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation))) - d5;
                d4 = this._arrowNode.getHeight() + this._balloonArrowSpacing;
            }
        } else if (this._arrowTailPosition == TOP_CENTER) {
            if (!bl) {
                d3 = -this._balloonNode.getWidth() / 2.0;
                d4 = 0.0;
            } else {
                d3 = -(this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation))) - this._balloonNode.getWidth() / 2.0;
                d4 = this._arrowNode.getHeight() + this._balloonArrowSpacing;
            }
        } else if (this._arrowTailPosition == TOP_RIGHT) {
            if (!bl) {
                d3 = -this._balloonNode.getWidth();
                d4 = 0.0;
            } else {
                d3 = -(this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation))) - this._balloonNode.getWidth() + d5;
                d4 = this._arrowNode.getHeight() + this._balloonArrowSpacing;
            }
        } else if (this._arrowTailPosition == BOTTOM_LEFT) {
            if (!bl) {
                d3 = 0.0;
                d4 = -this._balloonNode.getHeight();
            } else {
                d3 = this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation)) - d5;
                d4 = -(this._balloonNode.getHeight() + this._arrowNode.getHeight() + this._balloonArrowSpacing);
            }
        } else if (this._arrowTailPosition == BOTTOM_CENTER) {
            if (!bl) {
                d3 = -this._balloonNode.getWidth() / 2.0;
                d4 = -this._balloonNode.getHeight();
            } else {
                d3 = this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation)) - this._balloonNode.getWidth() / 2.0;
                d4 = -(this._balloonNode.getHeight() + this._arrowNode.getHeight() + this._balloonArrowSpacing);
            }
        } else if (this._arrowTailPosition == BOTTOM_RIGHT) {
            if (!bl) {
                d3 = -this._balloonNode.getWidth();
                d4 = -this._balloonNode.getHeight();
            } else {
                d3 = this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation)) - this._balloonNode.getWidth() + d5;
                d4 = -(this._balloonNode.getHeight() + this._arrowNode.getHeight() + this._balloonArrowSpacing);
            }
        } else if (this._arrowTailPosition == LEFT_TOP) {
            if (!bl) {
                d3 = 0.0;
                d4 = 0.0;
            } else {
                d3 = this._arrowNode.getWidth() + this._balloonArrowSpacing;
                d4 = this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation)) - d5;
            }
        } else if (this._arrowTailPosition == LEFT_CENTER) {
            if (!bl) {
                d3 = 0.0;
                d4 = -this._balloonNode.getHeight() / 2.0;
            } else {
                d3 = this._arrowNode.getWidth() + this._balloonArrowSpacing;
                d4 = this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation)) - this._balloonNode.getHeight() / 2.0;
            }
        } else if (this._arrowTailPosition == LEFT_BOTTOM) {
            if (!bl) {
                d3 = 0.0;
                d4 = -this._balloonNode.getHeight();
            } else {
                d3 = this._arrowNode.getWidth() + this._balloonArrowSpacing;
                d4 = this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation)) - this._balloonNode.getHeight() + d5;
            }
        } else if (this._arrowTailPosition == RIGHT_TOP) {
            if (!bl) {
                d3 = -this._balloonNode.getWidth();
                d4 = 0.0;
            } else {
                d3 = -(this._balloonNode.getWidth() + this._arrowNode.getWidth() + this._balloonArrowSpacing);
                d4 = -(this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation))) - d5;
            }
        } else if (this._arrowTailPosition == RIGHT_CENTER) {
            if (!bl) {
                d3 = -this._balloonNode.getWidth();
                d4 = -this._balloonNode.getHeight() / 2.0;
            } else {
                d3 = -(this._balloonNode.getWidth() + this._arrowNode.getWidth() + this._balloonArrowSpacing);
                d4 = -(this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation))) - this._balloonNode.getHeight() / 2.0;
            }
        } else if (this._arrowTailPosition == RIGHT_BOTTOM) {
            if (!bl) {
                d3 = -this._balloonNode.getWidth();
                d4 = -this._balloonNode.getHeight();
            } else {
                d3 = -(this._balloonNode.getWidth() + this._arrowNode.getWidth() + this._balloonArrowSpacing);
                d4 = -(this._arrowLength * Math.sin(Math.toRadians(this._arrowRotation))) - this._balloonNode.getHeight() + d5;
            }
        } else {
            throw new IllegalArgumentException("illegal arrow position: " + this._arrowTailPosition);
        }
        this._balloonNode.setOffset(d3, d4);
        if (this._shadowTextNode.getVisible()) {
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            if (this._shadowTextOffset.getWidth() > 0.0) {
                d6 = d3 + this._textMargin;
                d8 = d3 + this._textMargin + this._shadowTextOffset.getWidth();
            } else {
                d6 = d3 + this._textMargin + Math.abs(this._shadowTextOffset.getWidth());
                d8 = d3 + this._textMargin;
            }
            if (this._shadowTextOffset.getHeight() > 0.0) {
                d7 = d4 + this._textMargin;
                d9 = d4 + this._textMargin + this._shadowTextOffset.getHeight();
            } else {
                d7 = d4 + this._textMargin + Math.abs(this._shadowTextOffset.getHeight());
                d9 = d4 + this._textMargin;
            }
            this._textNode.setOffset(d6, d7);
            this._shadowTextNode.setOffset(d8, d9);
        } else {
            this._textNode.setOffset(d3 + this._textMargin, d4 + this._textMargin);
            this._shadowTextNode.setOffset(d3 + this._textMargin, d4 + this._textMargin);
        }
    }

    public Point2D mapLocation(PNode pNode, PCanvas pCanvas) {
        Point2D point2D = super.mapLocation(pNode, pCanvas);
        PBounds pBounds = pNode.getFullBounds();
        Rectangle2D rectangle2D = pNode.getParent().localToGlobal(pBounds);
        PCamera pCamera = pCanvas.getCamera();
        PAffineTransform pAffineTransform = pCamera.getViewTransformReference();
        Rectangle2D rectangle2D2 = pAffineTransform.transform(rectangle2D, null);
        double d = rectangle2D2.getWidth();
        double d2 = rectangle2D2.getHeight();
        if (this.isArrowOnTop()) {
            point2D.setLocation(point2D.getX() + d / 2.0, point2D.getY() + d2);
        } else if (this.isArrowOnBottom()) {
            point2D.setLocation(point2D.getX() + d / 2.0, point2D.getY());
        } else if (this.isArrowOnRight()) {
            point2D.setLocation(point2D.getX(), point2D.getY() + d2 / 2.0);
        } else {
            point2D.setLocation(point2D.getX() + d, point2D.getY() + d2 / 2.0);
        }
        return point2D;
    }

    public Point2D mapLocation(JComponent jComponent) {
        Point2D point2D = super.mapLocation(jComponent);
        double d = jComponent.getWidth();
        double d2 = jComponent.getHeight();
        if (this.isArrowOnTop()) {
            point2D.setLocation(point2D.getX() + d / 2.0, point2D.getY() + d2);
        } else if (this.isArrowOnBottom()) {
            point2D.setLocation(point2D.getX() + d / 2.0, point2D.getY());
        } else if (this.isArrowOnRight()) {
            point2D.setLocation(point2D.getX(), point2D.getY() + d2 / 2.0);
        } else {
            point2D.setLocation(point2D.getX() + d, point2D.getY() + d2 / 2.0);
        }
        return point2D;
    }

    public Point2D mapLocation(JComponent jComponent, PSwing pSwing, PCanvas pCanvas) {
        Point2D point2D = super.mapLocation(jComponent, pSwing, pCanvas);
        Rectangle rectangle = jComponent.getBounds();
        Rectangle2D rectangle2D = pSwing.getParent().localToGlobal(rectangle);
        PCamera pCamera = pCanvas.getCamera();
        PAffineTransform pAffineTransform = pCamera.getViewTransformReference();
        Rectangle2D rectangle2D2 = pAffineTransform.transform(rectangle2D, null);
        double d = rectangle2D2.getWidth();
        double d2 = rectangle2D2.getHeight();
        if (this.isArrowOnTop()) {
            point2D.setLocation(point2D.getX() + d / 2.0, point2D.getY() + d2);
        } else if (this.isArrowOnBottom()) {
            point2D.setLocation(point2D.getX() + d / 2.0, point2D.getY());
        } else if (this.isArrowOnRight()) {
            point2D.setLocation(point2D.getX(), point2D.getY() + d2 / 2.0);
        } else {
            point2D.setLocation(point2D.getX() + d, point2D.getY() + d2 / 2.0);
        }
        return point2D;
    }

    public static class Attachment {
        private String name;

        private Attachment(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            if (object instanceof Attachment) {
                Attachment attachment = (Attachment)object;
                return attachment.name.equals(this.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

