/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.recordandplayback.test;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.recordandplayback.gui.RecordAndPlaybackControlPanel;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.colorado.phet.recordandplayback.test.Particle;
import edu.colorado.phet.recordandplayback.test.ParticleNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

public class TestRecordAndPlaybackApplication
extends PhetApplication {
    public TestRecordAndPlaybackApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.addModule(new TestRecordAndPlaybackModule());
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(stringArray, "record-and-playback", TestRecordAndPlaybackApplication.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestRecordAndPlaybackModel
    extends RecordAndPlaybackModel<TestState> {
        private Particle particle;

        protected TestRecordAndPlaybackModel() {
            super(1000);
            this.particle = new Particle();
        }

        public Particle getParticle() {
            return this.particle;
        }

        @Override
        public TestState step(double d) {
            return new TestState(this.particle.getX(), this.particle.getY());
        }

        @Override
        public void setPlaybackState(TestState testState) {
            this.particle.setPosition(testState.getX(), testState.getY());
        }
    }

    private class TestRecordAndPlaybackModule
    extends Module {
        private TestRecordAndPlaybackModel model;

        public TestRecordAndPlaybackModule() {
            super("test record and playback", new SwingClock(30, 1.0));
            this.model = new TestRecordAndPlaybackModel();
            TestRecordAndPlaybackSimulationPanel testRecordAndPlaybackSimulationPanel = new TestRecordAndPlaybackSimulationPanel(this.model);
            this.setSimulationPanel(testRecordAndPlaybackSimulationPanel);
            this.getClock().addClockListener(new ClockAdapter(){

                public void simulationTimeChanged(ClockEvent clockEvent) {
                    TestRecordAndPlaybackModule.this.model.stepInTime(clockEvent.getSimulationTimeChange());
                }
            });
            this.setClockControlPanel(new RecordAndPlaybackControlPanel<TestState>(this.model, testRecordAndPlaybackSimulationPanel, 1000.0));
        }
    }

    private class TestRecordAndPlaybackSimulationPanel
    extends PhetPCanvas {
        private TestRecordAndPlaybackSimulationPanel(final TestRecordAndPlaybackModel testRecordAndPlaybackModel) {
            ParticleNode particleNode = new ParticleNode(testRecordAndPlaybackModel.getParticle());
            particleNode.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseDragged(PInputEvent pInputEvent) {
                    testRecordAndPlaybackModel.startRecording();
                }
            });
            this.addScreenChild(particleNode);
        }
    }

    public static class TestState {
        private double x;
        private double y;

        public TestState(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

