/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class JFreeChartCursorNode
extends PNode {
    private JFreeChartNode jFreeChartNode;
    private PhetPPath path;
    private double time;
    private double width = 9.0;
    private double minDragTime = Double.NEGATIVE_INFINITY;
    private double maxDragTime = Double.POSITIVE_INFINITY;
    private ArrayList<Listener> listeners = new ArrayList();
    final PropertyChangeListener updater = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JFreeChartCursorNode.this.update();
        }
    };
    private PropertyChangeListener updateParent = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (PNode pNode = JFreeChartCursorNode.this.jFreeChartNode.getParent(); pNode != null; pNode = pNode.getParent()) {
                pNode.removePropertyChangeListener("transform", JFreeChartCursorNode.this.updater);
                pNode.removePropertyChangeListener("parent", JFreeChartCursorNode.this.updateParent);
                pNode.addPropertyChangeListener("transform", JFreeChartCursorNode.this.updater);
                pNode.addPropertyChangeListener("parent", JFreeChartCursorNode.this.updateParent);
                JFreeChartCursorNode.this.update();
            }
        }
    };

    public JFreeChartCursorNode(final JFreeChartNode jFreeChartNode) {
        this.jFreeChartNode = jFreeChartNode;
        this.path = new PhetPPath(new Color(50, 50, 200, 80), (Stroke)new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 5.0f}, 0.0f), (Paint)Color.darkGray);
        this.addChild(this.path);
        jFreeChartNode.addPropertyChangeListener(this.updater);
        this.addPropertyChangeListener("transform", this.updater);
        this.addPropertyChangeListener("parent", this.updateParent);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){
            Point2D pressPoint;
            double pressTime;

            public void mousePressed(PInputEvent pInputEvent) {
                this.pressPoint = pInputEvent.getPositionRelativeTo(JFreeChartCursorNode.this);
                this.pressTime = JFreeChartCursorNode.this.time;
            }

            public Point2D localToPlotDifferential(double d, double d2) {
                Point2D point2D = new Point2D.Double(0.0, 0.0);
                Point2D point2D2 = new Point2D.Double(d, d2);
                JFreeChartCursorNode.this.localToGlobal(point2D);
                JFreeChartCursorNode.this.localToGlobal(point2D2);
                jFreeChartNode.globalToLocal(point2D);
                jFreeChartNode.globalToLocal(point2D2);
                point2D = jFreeChartNode.nodeToPlot(point2D);
                point2D2 = jFreeChartNode.nodeToPlot(point2D2);
                return new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getPositionRelativeTo(JFreeChartCursorNode.this);
                Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.pressPoint.getX(), point2D.getY() - this.pressPoint.getY());
                Point2D point2D2 = this.localToPlotDifferential(((Point2D)double_).getX(), ((Point2D)double_).getY());
                JFreeChartCursorNode.this.time = this.pressTime + point2D2.getX();
                JFreeChartCursorNode.this.time = MathUtil.clamp(JFreeChartCursorNode.this.getUpperBound(), JFreeChartCursorNode.this.time, JFreeChartCursorNode.this.getLowBound());
                JFreeChartCursorNode.this.update();
                JFreeChartCursorNode.this.notifySliderDragged();
            }
        });
        this.update();
    }

    public void setMaxDragTime(double d) {
        this.maxDragTime = d;
        if (this.getTime() > d) {
            this.setTime(d);
        }
    }

    private double getLowBound() {
        return Math.min(this.jFreeChartNode.getChart().getXYPlot().getDomainAxis().getRange().getUpperBound(), this.maxDragTime);
    }

    private double getUpperBound() {
        return Math.max(this.jFreeChartNode.getChart().getXYPlot().getDomainAxis().getRange().getLowerBound(), this.minDragTime);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifySliderDragged() {
        for (Listener listener : this.listeners) {
            listener.cursorTimeChanged();
        }
    }

    public void setTime(double d) {
        if (this.time != d) {
            this.time = d;
            this.update();
        }
    }

    public double getTime() {
        return this.time;
    }

    private void update() {
        Point2D point2D = this.jFreeChartNode.plotToNode(new Point2D.Double(this.time, this.jFreeChartNode.getChart().getXYPlot().getRangeAxis().getRange().getUpperBound()));
        Point2D point2D2 = this.jFreeChartNode.plotToNode(new Point2D.Double(this.time, this.jFreeChartNode.getChart().getXYPlot().getRangeAxis().getRange().getLowerBound()));
        this.jFreeChartNode.localToGlobal(point2D);
        this.jFreeChartNode.localToGlobal(point2D2);
        this.globalToLocal(point2D);
        this.globalToLocal(point2D2);
        this.path.setPathTo(new Rectangle2D.Double(point2D.getX() - this.width / 2.0, point2D.getY(), this.width, point2D2.getY() - point2D.getY()));
    }

    public static interface Listener {
        public void cursorTimeChanged();
    }
}

