/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo.dynamic;

import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesData;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesView;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PPathSeriesView
extends SeriesView {
    private PPath pathNode;
    private BasicStroke stroke = new BasicStroke(3.0f);
    private PNode root = new PNode();
    private PClip pathClip;
    private PropertyChangeListener listener;

    public PPathSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
        super(dynamicJFreeChartNode, seriesData);
        this.pathNode = this.createPPath();
        this.pathNode.setStroke(this.stroke);
        this.pathNode.setStrokePaint(seriesData.getColor());
        this.pathClip = new PClip();
        this.pathClip.setStrokePaint(null);
        this.root.addChild(this.pathClip);
        this.pathClip.addChild(this.pathNode);
        this.updateClip();
        dynamicJFreeChartNode.getPhetPCanvas().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PPathSeriesView.this.updateAll();
            }
        });
        dynamicJFreeChartNode.addBufferedPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PPathSeriesView.this.updateAll();
            }
        });
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PPathSeriesView.this.updateAll();
            }
        };
    }

    protected PPath createPPath() {
        return new PPath();
    }

    public void dataAdded() {
        int n = this.getSeries().getItemCount();
        float f = (float)this.getNodePoint(n - 1).getX();
        float f2 = (float)this.getNodePoint(n - 1).getY();
        if (this.pathNode.getPathReference().getCurrentPoint() == null) {
            this.pathNode.moveTo(f, f2);
        } else if (this.getSeries().getItemCount() >= 2) {
            this.pathNode.lineTo(f, f2);
        }
    }

    public void dataCleared() {
        this.pathNode.getPathReference().reset();
    }

    public void uninstall() {
        super.uninstall();
        super.getDynamicJFreeChartNode().removeChild(this.root);
        this.getDynamicJFreeChartNode().removeChartRenderingInfoPropertyChangeListener(this.listener);
        this.getDynamicJFreeChartNode().removeBufferedImagePropertyChangeListener(this.listener);
    }

    public void install() {
        super.install();
        this.getDynamicJFreeChartNode().addChild(this.root);
        this.getDynamicJFreeChartNode().addChartRenderingInfoPropertyChangeListener(this.listener);
        this.getDynamicJFreeChartNode().addBufferedImagePropertyChangeListener(this.listener);
        this.updateClip();
        this.updateAll();
    }

    protected void forceRepaintAll() {
        this.updateAll();
    }

    private void updateAll() {
        this.updateClip();
        this.updatePath();
    }

    private void updateClip() {
        this.pathClip.setPathTo(this.getDataArea());
    }

    private void updatePath() {
        this.pathNode.setPathTo(this.toGeneralPath());
    }
}

