/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo.dynamic;

import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesData;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.data.xy.XYSeries;

public abstract class SeriesView {
    private DynamicJFreeChartNode dynamicJFreeChartNode;
    private SeriesData seriesData;
    private SeriesData.Listener listener = new SeriesData.Listener(){

        public void dataAdded() {
            SeriesView.this.dataAdded();
        }

        public void dataCleared() {
            SeriesView.this.dataCleared();
        }
    };

    public SeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
        this.dynamicJFreeChartNode = dynamicJFreeChartNode;
        this.seriesData = seriesData;
    }

    public abstract void dataAdded();

    public abstract void dataCleared();

    public void uninstall() {
        this.seriesData.removeListener(this.listener);
    }

    public void install() {
        this.seriesData.addListener(this.listener);
    }

    public DynamicJFreeChartNode getDynamicJFreeChartNode() {
        return this.dynamicJFreeChartNode;
    }

    public XYSeries getSeries() {
        return this.seriesData.getSeries();
    }

    public SeriesData getSeriesData() {
        return this.seriesData;
    }

    public Point2D.Double getPoint(int n) {
        return new Point2D.Double(this.getSeries().getX(n).doubleValue(), this.getSeries().getY(n).doubleValue());
    }

    public Point2D getNodePoint(int n) {
        return this.getDynamicJFreeChartNode().plotToNode(this.getPoint(n));
    }

    public Rectangle2D getDataArea() {
        return this.getDynamicJFreeChartNode().getDataArea();
    }

    protected GeneralPath toGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        if (this.getSeries().getItemCount() > 0) {
            generalPath.moveTo((float)this.getNodePoint(0).getX(), (float)this.getNodePoint(0).getY());
        }
        for (int i = 1; i < this.getSeries().getItemCount(); ++i) {
            generalPath.lineTo((float)this.getNodePoint(i).getX(), (float)this.getNodePoint(i).getY());
        }
        return generalPath;
    }

    protected abstract void forceRepaintAll();
}

