/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.awt.geom.Point2D;
import java.io.Serializable;

public class ImmutableVector2D
implements Serializable {
    private double x;
    private double y;
    public static final ImmutableVector2D ZERO = new ImmutableVector2D();

    public ImmutableVector2D() {
        this(0.0, 0.0);
    }

    public ImmutableVector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public ImmutableVector2D(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public ImmutableVector2D(Point2D point2D, Point2D point2D2) {
        this(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this.getClass() != object.getClass()) {
            bl = false;
        } else {
            ImmutableVector2D immutableVector2D = (ImmutableVector2D)object;
            bl = this.getX() == immutableVector2D.getX() && this.getY() == immutableVector2D.getY();
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getName().replaceAll(".*\\.", "") + "[" + this.x + ", " + this.y + "]";
    }

    public ImmutableVector2D getAddedInstance(ImmutableVector2D immutableVector2D) {
        return this.getAddedInstance(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public ImmutableVector2D getAddedInstance(double d, double d2) {
        return new ImmutableVector2D(this.getX() + d, this.getY() + d2);
    }

    public ImmutableVector2D getScaledInstance(double d) {
        return new ImmutableVector2D(this.getX() * d, this.getY() * d);
    }

    public ImmutableVector2D getNormalVector() {
        return new ImmutableVector2D(this.y, -this.x);
    }

    public ImmutableVector2D getNormalizedInstance() {
        double d = this.getMagnitude();
        if (d == 0.0) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return new ImmutableVector2D(this.getX() / d, this.getY() / d);
    }

    public ImmutableVector2D getSubtractedInstance(double d, double d2) {
        return new ImmutableVector2D(this.getX() - d, this.getY() - d2);
    }

    public ImmutableVector2D getSubtractedInstance(ImmutableVector2D immutableVector2D) {
        return this.getSubtractedInstance(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getMagnitudeSq() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSq());
    }

    protected void setX(double d) {
        this.x = d;
    }

    protected void setY(double d) {
        this.y = d;
    }

    public double dot(ImmutableVector2D immutableVector2D) {
        double d = 0.0;
        d += this.getX() * immutableVector2D.getX();
        return d += this.getY() * immutableVector2D.getY();
    }

    public double getAngle() {
        return Math.atan2(this.y, this.x);
    }

    public ImmutableVector2D getInstanceOfMagnitude(double d) {
        return this.getScaledInstance(d / this.getMagnitude());
    }

    public Point2D.Double toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D.Double getDestination(Point2D point2D) {
        return new Point2D.Double(point2D.getX() + this.getX(), point2D.getY() + this.getY());
    }

    public ImmutableVector2D getRotatedInstance(double d) {
        return ImmutableVector2D.createPolar(this.getMagnitude(), this.getAngle() + d);
    }

    public static ImmutableVector2D createPolar(double d, double d2) {
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(Math.cos(d2), Math.sin(d2));
        return immutableVector2D.getScaledInstance(d);
    }

    public ImmutableVector2D plus(double d, double d2) {
        return this.getAddedInstance(d, d2);
    }

    public ImmutableVector2D plus(ImmutableVector2D immutableVector2D) {
        return this.getAddedInstance(immutableVector2D);
    }

    public ImmutableVector2D minus(ImmutableVector2D immutableVector2D) {
        return this.getSubtractedInstance(immutableVector2D);
    }

    public ImmutableVector2D times(double d) {
        return this.getScaledInstance(d);
    }
}

