/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing.components;

import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JCheckBox;

public class SimSharingJCheckBox
extends JCheckBox {
    private final IUserComponent userComponent;
    private ArrayList<Function0<ParameterSet>> customParameterFunctions = new ArrayList();

    public SimSharingJCheckBox(IUserComponent iUserComponent, String string) {
        super(string);
        this.userComponent = iUserComponent;
        this.enableMouseEvents();
    }

    private void enableMouseEvents() {
        this.enableEvents(16L);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && !this.isEnabled()) {
            this.sendUserMessage(this.getParameters().with((IParameterKey)ParameterKeys.enabled, this.isEnabled()).with((IParameterKey)ParameterKeys.interactive, this.isEnabled()));
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        this.sendUserMessage(this.getParameters());
        super.fireActionPerformed(actionEvent);
    }

    private ParameterSet getParameters() {
        return new ParameterSet().with((IParameterKey)ParameterKeys.isSelected, this.isSelected()).with(this.getCustomParameters());
    }

    protected ParameterSet getCustomParameters() {
        ParameterSet parameterSet = new ParameterSet();
        for (Function0<ParameterSet> function0 : this.customParameterFunctions) {
            parameterSet.with(function0.apply());
        }
        return parameterSet;
    }

    private void sendUserMessage(ParameterSet parameterSet) {
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.checkBox, UserActions.pressed, parameterSet);
    }
}

