/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.sponsorship;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponents;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.sponsorship.SponsorPanel;
import edu.colorado.phet.common.phetcommon.sponsorship.SponsorProperties;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.Timer;

public class SponsorDialog
extends JDialog {
    private SponsorDialog(PhetApplicationConfig phetApplicationConfig, Frame frame) {
        super(frame);
        this.setResizable(false);
        this.setContentPane(new SponsorPanel(phetApplicationConfig));
        SwingUtils.setBackgroundDeep(this, Color.WHITE);
        this.pack();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SimSharingManager.sendUserMessage(UserComponents.sponsorDialog, UserComponentTypes.dialog, UserActions.pressed);
                SponsorDialog.this.dispose();
            }
        });
    }

    public static JDialog show(PhetApplicationConfig phetApplicationConfig, Frame frame, boolean bl) {
        final SponsorDialog sponsorDialog = new SponsorDialog(phetApplicationConfig, frame);
        sponsorDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SimSharingManager.sendUserMessage(UserComponents.sponsorDialog, UserComponentTypes.dialog, UserActions.windowClosing);
                sponsorDialog.dispose();
            }
        });
        SwingUtils.centerInParent(sponsorDialog);
        sponsorDialog.setVisible(true);
        if (bl) {
            final Timer timer = new Timer(5000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (sponsorDialog.isDisplayable()) {
                        SimSharingManager.sendSystemMessage(SystemComponents.sponsorDialog, SystemComponentTypes.dialog, SystemActions.windowClosed);
                        sponsorDialog.dispose();
                    }
                }
            });
            timer.setRepeats(false);
            sponsorDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    timer.stop();
                }
            });
            timer.start();
        }
        return sponsorDialog;
    }

    public static boolean shouldShow(PhetApplicationConfig phetApplicationConfig) {
        boolean bl = phetApplicationConfig.isSponsorFeatureEnabled();
        boolean bl2 = new SponsorProperties(phetApplicationConfig).isWellFormed();
        return bl && bl2;
    }
}

