/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class PhetOptionPane {
    private static final String TITLE_MESSAGE = PhetCommonResources.getInstance().getLocalizedString("Common.title.message");
    private static final String TITLE_CONFIRM = PhetCommonResources.getInstance().getLocalizedString("Common.title.confirm");
    private static final String TITLE_WARNING = PhetCommonResources.getInstance().getLocalizedString("Common.title.warning");
    private static final String TITLE_ERROR = PhetCommonResources.getInstance().getLocalizedString("Common.title.error");

    public static int showMessageDialog(Component component, Object object) {
        return PhetOptionPane.showMessageDialog(component, object, TITLE_MESSAGE);
    }

    public static int showMessageDialog(Component component, Object object, String string) {
        return PhetOptionPane.showMessageDialog(component, object, string, 1);
    }

    public static int showMessageDialog(Component component, Object object, String string, int n) {
        return PhetOptionPane.showJOptionPaneDialog(component, object, string, n);
    }

    public static int showYesNoDialog(Component component, Object object) {
        return PhetOptionPane.showYesNoDialog(component, object, TITLE_CONFIRM);
    }

    public static int showYesNoDialog(Component component, Object object, String string) {
        return PhetOptionPane.showJOptionPaneDialog(component, object, string, 3, 0);
    }

    private static int showJOptionPaneDialog(Component component, Object object, String string, int n) {
        return PhetOptionPane.showJOptionPaneDialog(component, object, string, n, -1);
    }

    private static int showJOptionPaneDialog(Component component, Object object, String string, int n, int n2) {
        JOptionPane jOptionPane = new JOptionPane(object, n, n2);
        jOptionPane.selectInitialValue();
        final JDialog jDialog = PhetOptionPane.createDialog(component, string);
        jDialog.getContentPane().add(jOptionPane);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("value")) {
                    jDialog.setVisible(false);
                }
            }
        });
        jDialog.pack();
        SwingUtils.centerDialog(jDialog, component);
        jDialog.setVisible(true);
        jDialog.dispose();
        int n3 = -1;
        Object object2 = jOptionPane.getValue();
        if (object2 instanceof Integer) {
            n3 = (Integer)object2;
        }
        return n3;
    }

    private static JDialog createDialog(Component component, String string) {
        PaintImmediateDialog paintImmediateDialog = null;
        Window window = PhetOptionPane.getWindowForComponent(component);
        paintImmediateDialog = window instanceof Frame ? new PaintImmediateDialog((Frame)window, string) : new PaintImmediateDialog((Dialog)window, string);
        paintImmediateDialog.setModal(true);
        paintImmediateDialog.setResizable(false);
        return paintImmediateDialog;
    }

    private static Window getWindowForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return PhetOptionPane.getWindowForComponent(component.getParent());
    }
}

