/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Cursor;
import javax.swing.JComponent;

public class CursorHandler
extends PBasicInputEventHandler {
    public static final Cursor CROSSHAIR = Cursor.getPredefinedCursor(1);
    public static final Cursor DEFAULT = Cursor.getPredefinedCursor(0);
    public static final Cursor HAND = Cursor.getPredefinedCursor(12);
    protected static final CursorManager manager = new CursorManager();
    protected Cursor cursor;

    public CursorHandler() {
        this(HAND);
    }

    public CursorHandler(int n) {
        this(Cursor.getPredefinedCursor(n));
    }

    public CursorHandler(Cursor cursor) {
        this.cursor = cursor;
    }

    public void mouseEntered(PInputEvent pInputEvent) {
        manager.mouseEntered((JComponent)((Object)pInputEvent.getComponent()), this.cursor);
    }

    public void mousePressed(PInputEvent pInputEvent) {
        manager.mousePressed();
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        manager.mouseReleased((JComponent)((Object)pInputEvent.getComponent()));
    }

    public void mouseExited(PInputEvent pInputEvent) {
        this.mouseExited((JComponent)((Object)pInputEvent.getComponent()));
    }

    public void mouseExited(JComponent jComponent) {
        manager.mouseExited(jComponent);
    }

    protected static class CursorManager {
        protected Cursor lastEntered;
        boolean pressed = false;

        private CursorManager() {
        }

        public void mouseEntered(JComponent jComponent, Cursor cursor) {
            if (!this.pressed) {
                jComponent.setCursor(cursor);
            }
            this.lastEntered = cursor;
        }

        public void mousePressed() {
            this.pressed = true;
        }

        public void mouseReleased(JComponent jComponent) {
            if (this.lastEntered != null) {
                jComponent.setCursor(this.lastEntered);
            } else {
                jComponent.setCursor(Cursor.getDefaultCursor());
            }
            this.pressed = false;
        }

        public void mouseExited(JComponent jComponent) {
            if (!this.pressed) {
                jComponent.setCursor(Cursor.getDefaultCursor());
            }
            this.lastEntered = null;
        }
    }
}

