/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.slider;

import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SliderNode
extends PNode {
    private final IUserComponent userComponent;
    public final double min;
    public final double max;
    public final SettableProperty<Double> value;
    private final ArrayList<Double> dragValues = new ArrayList();

    public SliderNode(IUserComponent iUserComponent, double d, double d2, SettableProperty<Double> settableProperty) {
        this.userComponent = iUserComponent;
        this.min = d;
        this.max = d2;
        this.value = settableProperty;
    }

    protected void dragStarted() {
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.slider, UserActions.startDrag, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, (Double)this.value.get()));
        this.dragValues.clear();
        this.dragValues.add((Double)this.value.get());
    }

    protected void dragged() {
        this.dragValues.add((Double)this.value.get());
    }

    protected void dragEnded() {
        this.dragValues.add((Double)this.value.get());
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.slider, UserActions.endDrag, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, (Double)this.value.get()).with((IParameterKey)ParameterKeys.numberDragEvents, this.dragValues.size()).with((IParameterKey)ParameterKeys.minValue, Collections.min(this.dragValues)).with((IParameterKey)ParameterKeys.maxValue, Collections.max(this.dragValues)).with((IParameterKey)ParameterKeys.averageValue, SliderNode.average(this.dragValues)));
        this.dragValues.clear();
    }

    private static double average(ArrayList<Double> arrayList) {
        double d = 0.0;
        for (Double d2 : arrayList) {
            d += d2.doubleValue();
        }
        return d / (double)arrayList.size();
    }
}

