/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.timeseries.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.timeseries.model.Mode;
import edu.colorado.phet.common.timeseries.model.RecordableModel;
import edu.colorado.phet.common.timeseries.model.TimeStateSeries;
import java.util.ArrayList;

public class TimeSeriesModel
extends ClockAdapter {
    private RecordableModel recordableModel;
    private ConstantDtClock clock;
    private TimeStateSeries series = new TimeStateSeries();
    private double maxRecordTime = Double.POSITIVE_INFINITY;
    private Mode.Record record = new Mode.Record(this);
    private Mode.Playback playback = new Mode.Playback(this);
    private Mode.Live live = new Mode.Live(this);
    private Mode mode = this.live;
    private ArrayList<Listener> listeners = new ArrayList();
    private boolean paused;

    public TimeSeriesModel(RecordableModel recordableModel, ConstantDtClock constantDtClock) {
        this.recordableModel = recordableModel;
        this.clock = constantDtClock;
        this.paused = constantDtClock.isPaused();
        constantDtClock.addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                TimeSeriesModel.this.updatePauseStateFromClock();
            }

            public void clockPaused(ClockEvent clockEvent) {
                TimeSeriesModel.this.updatePauseStateFromClock();
            }
        });
    }

    private void updatePauseStateFromClock() {
        if (this.paused != this.clock.isPaused()) {
            this.paused = this.clock.isPaused();
            this.notifyPauseChanged();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void addPlaybackTimeChangeListener(PlaybackTimeListener playbackTimeListener) {
        this.playback.addListener(playbackTimeListener);
    }

    public double getPlaybackTime() {
        return this.playback.getPlaybackTime();
    }

    public void setPlaybackTime(double d) {
        if (d > this.getRecordTime()) {
            d = this.getRecordTime();
        }
        if (d >= 0.0 && d <= this.getRecordTime()) {
            this.playback.setTime(d);
            if (this.numPlaybackStates() > 0) {
                this.recordableModel.setState(this.series.getTimeStateValue(d));
            }
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getRecordTime() {
        return this.record.getRecordTime();
    }

    public void setPaused(boolean bl) {
        if (this.paused != bl) {
            if (bl) {
                this.clock.pause();
            } else {
                this.clock.start();
            }
            this.notifyPauseChanged();
        }
    }

    private void notifyPauseChanged() {
        for (Listener listener : this.listeners) {
            listener.pauseChanged();
        }
    }

    public void reset() {
        boolean bl = this.isPaused();
        this.setPaused(true);
        this.record.reset();
        this.series.clear();
        this.recordableModel.resetTime();
        this.setPaused(bl);
        this.notifyDataSeriesChanged();
    }

    public boolean isLiveMode() {
        return this.mode == this.live;
    }

    public void setRecordMode() {
        this.setMode(this.record);
    }

    protected void setMode(Mode mode) {
        boolean bl;
        boolean bl2 = bl = mode == this.mode;
        if (!bl) {
            this.mode = mode;
            this.notifyModeChanged();
        }
    }

    private void notifyModeChanged() {
        for (Listener listener : this.listeners) {
            listener.modeChanged();
        }
    }

    public void rewind() {
        this.setPlaybackTime(this.getRecordStartTime());
    }

    private double getRecordStartTime() {
        if (this.series.numPoints() > 0) {
            return this.series.getStartTime();
        }
        return 0.0;
    }

    private void notifyDataSeriesChanged() {
        for (Listener listener : this.listeners) {
            listener.dataSeriesChanged();
        }
    }

    public boolean isPlaybackMode() {
        return this.mode == this.playback;
    }

    public boolean isRecording() {
        return this.mode == this.record && !this.isPaused();
    }

    public double getMaxRecordTime() {
        return this.maxRecordTime;
    }

    public void addSeriesPoint(Object object, double d) {
        this.series.addPoint(object, d);
        this.notifyDataSeriesChanged();
    }

    public void startLiveMode() {
        this.setLiveMode();
        this.setPaused(false);
        this.notifyDataSeriesChanged();
    }

    public void setLiveMode() {
        this.setMode(this.live);
    }

    public void updateModel(double d) {
        this.recordableModel.stepInTime(d);
    }

    public Object getModelState() {
        return this.recordableModel.getState();
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean bl) {
        if (this.series.size() > 0 || bl) {
            this.series.clear();
            this.record.reset();
            this.recordableModel.clear();
            this.setPaused(true);
            this.setPlaybackTime(0.0);
            this.notifyDataSeriesChanged();
            this.notifyDataSeriesCleared();
        }
    }

    private void notifyDataSeriesCleared() {
        for (Listener listener : this.listeners) {
            listener.dataSeriesCleared();
        }
    }

    public int numPlaybackStates() {
        return this.series.numPoints();
    }

    public void setMaxAllowedRecordTime(double d) {
        this.maxRecordTime = d;
    }

    public void recordFinished() {
        this.setLiveMode();
    }

    public ConstantDtClock getTimeModelClock() {
        return this.clock;
    }

    public void clockTicked(ClockEvent clockEvent) {
        this.stepMode(clockEvent.getSimulationTimeChange());
    }

    public void clockStarted(ClockEvent clockEvent) {
        this.notifyPauseChanged();
    }

    public void clockPaused(ClockEvent clockEvent) {
        this.notifyPauseChanged();
    }

    public void stepMode(double d) {
        this.mode.step(d);
    }

    public void setPlaybackMode() {
        this.setMode(this.playback);
    }

    public static class Adapter
    implements Listener {
        public void dataSeriesChanged() {
        }

        public void modeChanged() {
        }

        public void pauseChanged() {
        }

        public void dataSeriesCleared() {
        }
    }

    public static interface Listener {
        public void dataSeriesChanged();

        public void modeChanged();

        public void pauseChanged();

        public void dataSeriesCleared();
    }

    public static interface PlaybackTimeListener {
        public void timeChanged();
    }
}

