/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkOptions;
import edu.colorado.phet.energyskatepark.serialization.EnergySkateParkIO;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkLookAndFeel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkOptionsMenu;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkTestMenu;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkTrackMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class EnergySkateParkApplication
extends PhetApplication {
    private final AbstractEnergySkateParkModule module = new EnergySkateParkModule(null, "Module", this.getPhetFrame(), new EnergySkateParkOptions(), false, true);
    public static final double SIMULATION_TIME_DT = 0.03;
    public static final boolean IGNORE_THERMAL_DEFAULT = false;

    public EnergySkateParkApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.setModules(new Module[]{this.module});
        if (phetApplicationConfig.isDev()) {
            this.getPhetFrame().addMenu(new EnergySkateParkOptionsMenu(this.module));
        }
        if (phetApplicationConfig.isDev()) {
            this.getPhetFrame().addMenu(new EnergySkateParkTestMenu(this));
        }
        this.getPhetFrame().addMenu(new EnergySkateParkTrackMenu(this));
        JMenuItem jMenuItem = new JMenuItem(EnergySkateParkResources.getString("file-menu.save") + "...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EnergySkateParkIO.save(EnergySkateParkApplication.this.module);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(EnergySkateParkResources.getString("file-menu.open") + "...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EnergySkateParkIO.open(EnergySkateParkApplication.this.module);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.getPhetFrame().addFileMenuItem(jMenuItem2);
        this.getPhetFrame().addFileMenuItem(jMenuItem);
        this.getPhetFrame().addFileMenuSeparator();
    }

    public AbstractEnergySkateParkModule getModule() {
        return this.module;
    }

    public void startApplication() {
        super.startApplication();
        this.module.getPhetPCanvas().requestFocus();
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new EnergySkateParkApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "energy-skate-park");
        phetApplicationConfig.setLookAndFeel(new EnergySkateParkLookAndFeel());
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

