/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.basics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.basics.TrackButton;
import edu.colorado.phet.energyskatepark.basics.ViewControlPanel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkOptions;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.Planet;
import edu.colorado.phet.energyskatepark.serialization.EnergySkateParkIO;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkLookAndFeel;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EnergySkateParkBasicsModule
extends AbstractEnergySkateParkModule {
    public final ControlPanelNode controlPanel;
    private final String PARABOLA_TRACK = "parabola";
    public static final Font CONTROL_FONT = new PhetFont(15);
    public static final Font TITLE_FONT = new PhetFont(1, 16);
    public final BooleanProperty frictionEnabled = new BooleanProperty(false);
    public final BooleanProperty stickToTrack = new BooleanProperty(true);
    public final Property<String> currentTrackFileName = new Property<String>("");
    public final Property<Double> frictionAmount = new Property<Double>(0.0);
    public static final ImmutableVector2D PARABOLA_OFFSET = new ImmutableVector2D(-0.5, 0.0);
    public static final ImmutableVector2D DOUBLE_WELL_OFFSET = new ImmutableVector2D(-0.8803350954568696, 0.02);
    public static final ImmutableVector2D RAMP_TO_FLOOR_OFFSET = ImmutableVector2D.ZERO;

    public EnergySkateParkBasicsModule(IUserComponent iUserComponent, String string, PhetFrame phetFrame, boolean bl) {
        super(iUserComponent, string, phetFrame, new EnergySkateParkOptions(), bl, bl, 0.0, false, 3.0, true, false);
        this.energySkateParkSimulationPanel.setThrustEnabled(false);
        new Planet.Earth().apply(this);
        this.setControlPanel(null);
        this.stickToTrack.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                EnergySkateParkBasicsModule.this.getEnergySkateParkModel().setRollerCoasterMode(bl);
            }
        });
        this.controlPanel = this.createControlPanel();
        this.energySkateParkSimulationPanel.getRootNode().addLayoutListener(new VoidFunction0(){

            public void apply() {
                EnergySkateParkBasicsModule.this.controlPanel.setOffset((double)EnergySkateParkBasicsModule.this.energySkateParkSimulationPanel.getWidth() - EnergySkateParkBasicsModule.this.controlPanel.getFullBounds().getWidth() - 5.0, 5.0);
            }
        });
        this.energySkateParkSimulationPanel.getRootNode().controlLayer.addChild(this.controlPanel);
        this.energySkateParkSimulationPanel.getRootNode().addLayoutListener(new VoidFunction0(){

            public void apply() {
                EnergySkateParkBasicsModule.this.energySkateParkSimulationPanel.getRootNode().getLegend().translate(-EnergySkateParkBasicsModule.this.controlPanel.getFullBounds().getWidth() - 5.0, 0.0);
            }
        });
    }

    protected ControlPanelNode createControlPanel() {
        return new ViewControlPanel(this);
    }

    public void loadTrack(String string, ImmutableVector2D immutableVector2D) {
        EnergySkateParkIO.open("energy-skate-park/tracks/basics/" + string + ".esp", this);
        this.currentTrackFileName.set(string);
        this.getEnergySkateParkModel().setRollerCoasterMode((Boolean)this.stickToTrack.get());
        this.adjustSplines(immutableVector2D);
        this.initSkater();
    }

    public void initSkater() {
        this.getEnergySkateParkModel().getBody(0).setPosition(10.0, 0.0);
        this.getEnergySkateParkModel().getBody(0).setVelocity(0.0, 0.0);
        this.getEnergySkateParkModel().getBody(0).setFrictionCoefficient(this.getCoefficientOfFriction());
        this.getEnergySkateParkModel().getBody(0).setRestorePoint(this.getEnergySkateParkModel().getBody(0));
        this.getEnergySkateParkModel().getBody(0).switchToTrack(this.getEnergySkateParkModel().getFloor().getParametricFunction2D(), false, 0.36666702272486873);
        this.getEnergySkateParkModel().getBody(0).updateStateFromParticle();
    }

    protected void loadDefaultTrack() {
        this.loadTrack("parabola", PARABOLA_OFFSET);
    }

    private void adjustSplines(ImmutableVector2D immutableVector2D) {
        for (int i = 0; i < this.getEnergySkateParkModel().getNumSplines(); ++i) {
            EnergySkateParkSpline energySkateParkSpline = this.getEnergySkateParkModel().getSpline(i);
            energySkateParkSpline.translate(immutableVector2D.getX(), -energySkateParkSpline.getMinControlPointY() + immutableVector2D.getY());
        }
    }

    public void addResetAndRestartButtons(final PNode pNode) {
        final TextButtonNode textButtonNode = new TextButtonNode(EnergySkateParkResources.getString("controls.reset-character")){
            {
                this.setUserComponent(EnergySkateParkSimSharing.UserComponents.returnSkaterButton);
                this.setFont(CONTROL_FONT);
                this.setBackground(Color.ORANGE);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EnergySkateParkBasicsModule.this.returnOrResetSkater();
                    }
                });
            }
        };
        final TextButtonNode textButtonNode2 = new TextButtonNode(PhetCommonResources.getInstance().getLocalizedString("ControlPanel.button.resetAll")){
            {
                this.setUserComponent(UserComponents.resetAllButton);
                this.setFont(CONTROL_FONT);
                this.setBackground(Color.YELLOW);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EnergySkateParkBasicsModule.this.reset();
                    }
                });
            }
        };
        this.energySkateParkSimulationPanel.getRootNode().addLayoutListener(new VoidFunction0(){

            public void apply() {
                textButtonNode.setOffset(EnergySkateParkBasicsModule.this.controlPanel.getFullBounds().getCenterX() - textButtonNode.getFullBounds().getWidth() / 2.0, pNode.getFullBounds().getMaxY() + 10.0);
                textButtonNode2.setOffset(EnergySkateParkBasicsModule.this.controlPanel.getFullBounds().getCenterX() - textButtonNode2.getFullBounds().getWidth() / 2.0, textButtonNode.getFullBounds().getMaxY() + 10.0);
            }
        });
        this.energySkateParkSimulationPanel.getRootNode().addChild(textButtonNode);
        this.energySkateParkSimulationPanel.getRootNode().addChild(textButtonNode2);
    }

    public void addTrackSelectionControlPanel() {
        ControlPanelNode controlPanelNode = new ControlPanelNode((PNode)new VBox(new TrackButton(this, "parabola", PARABOLA_OFFSET), new TrackButton(this, "rampToFloor", RAMP_TO_FLOOR_OFFSET), new TrackButton(this, "doubleWell", DOUBLE_WELL_OFFSET)), EnergySkateParkLookAndFeel.backgroundColor){
            {
                EnergySkateParkBasicsModule.this.energySkateParkSimulationPanel.getRootNode().addLayoutListener(new VoidFunction0(){

                    public void apply() {
                        this.setOffset(5.0, 5.0);
                    }
                });
            }
        };
        this.energySkateParkSimulationPanel.getRootNode().addChild(controlPanelNode);
    }

    public void reset() {
        super.reset();
        this.frictionEnabled.set(true);
        this.frictionAmount.reset();
        this.frictionEnabled.reset();
        this.stickToTrack.reset();
        this.loadDefaultTrack();
    }
}

