/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.basics;

import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.slider.HSliderNode;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.basics.EnergySkateParkBasicsModule;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;

public class TrackFrictionSlider
extends PNode {
    private final Property<Double> savedFrictionValue = new Property<Double>(0.005);

    public TrackFrictionSlider(final EnergySkateParkBasicsModule energySkateParkBasicsModule) {
        final Property<Double> property = energySkateParkBasicsModule.frictionAmount;
        property.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                energySkateParkBasicsModule.setCoefficientOfFriction(d);
            }
        });
        HSliderNode hSliderNode = new HSliderNode(EnergySkateParkSimSharing.UserComponents.trackFrictionSlider, 0.0, 0.01, 5.0, 90.0, property, energySkateParkBasicsModule.frictionEnabled){
            {
                this.setTrackFillPaint(Color.white);
            }
        };
        hSliderNode.addLabel(0.0, new PText(EnergySkateParkResources.getString("controls.gravity.none")));
        hSliderNode.addLabel(0.01, new PText(EnergySkateParkResources.getString("controls.gravity.lots")));
        this.addChild(hSliderNode);
        energySkateParkBasicsModule.frictionEnabled.addObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                if (bl.booleanValue() && !bl2.booleanValue()) {
                    property.set(TrackFrictionSlider.this.savedFrictionValue.get());
                } else if (bl2.booleanValue() && !bl.booleanValue()) {
                    TrackFrictionSlider.this.savedFrictionValue.set(property.get());
                    property.set(0.0);
                }
            }
        });
        energySkateParkBasicsModule.addResetListener(new VoidFunction0(){

            public void apply() {
                TrackFrictionSlider.this.savedFrictionValue.reset();
            }
        });
    }
}

