/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;

public class BumpUpSplines {
    private final EnergySkateParkModel model;
    private final ImmutableRectangle2D bounds;

    public BumpUpSplines(EnergySkateParkModel energySkateParkModel, ImmutableRectangle2D immutableRectangle2D) {
        this.model = energySkateParkModel;
        this.bounds = immutableRectangle2D;
    }

    public void bumpUpSplines() {
        for (int i = 0; i < this.model.getNumSplines(); ++i) {
            EnergySkateParkSpline energySkateParkSpline = this.model.getSpline(i);
            if (energySkateParkSpline.getMinY() < 0.01) {
                energySkateParkSpline.translate(0.0, Math.abs(energySkateParkSpline.getMinY()) + 0.01 + 1.0E-6);
            } else if (energySkateParkSpline.getMaxY() > this.bounds.getMaxY()) {
                energySkateParkSpline.translate(0.0, -energySkateParkSpline.getMaxY() + this.bounds.getMaxY());
            }
            if (energySkateParkSpline.getMinX() < this.bounds.x) {
                energySkateParkSpline.translate(-energySkateParkSpline.getMinX() + this.bounds.x, 0.0);
                continue;
            }
            if (!(energySkateParkSpline.getMaxX() > this.bounds.getMaxX())) continue;
            energySkateParkSpline.translate(-energySkateParkSpline.getMaxX() + this.bounds.getMaxX(), 0.0);
        }
    }
}

