/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.energyskatepark.model.physics.TestState;
import java.util.ArrayList;

public class DefaultTestSet {
    private final ArrayList tests = new ArrayList();
    private final TestState dualTrackTest = new TestState.SplineTestState("Dual Track Test", 0, 0.92, 0.0, false);
    private final TestState.SplineTestState upsideDownLoop;
    private final TestState.SplineTestState fallThroughValley;
    private final TestState.FreeFallTestState fallThroughValley2;
    private final TestState.SplineTestState fallThroughPeak;
    private final TestState.SplineTestState fallOffSteep;
    private final TestState.SplineTestState testApproachPeak;

    public DefaultTestSet() {
        this.dualTrackTest.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(4.560000000000002, 5.269999999999993), new SerializablePoint2D(3.4899999999999984, 3.1999999999999953), new SerializablePoint2D(4.999999999999996, 3.3499999999999908), new SerializablePoint2D(3.1999999999999966, 5.2099999999999875), new SerializablePoint2D(1.009999999999998, 2.1999999999999984)});
        this.dualTrackTest.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(0.0, 0.0), new SerializablePoint2D(1.0, 1.0), new SerializablePoint2D(2.0, 2.0)});
        this.tests.add(this.dualTrackTest);
        this.upsideDownLoop = new TestState.SplineTestState("Upside Down Loop", 0, 1.0, 0.0, false);
        this.upsideDownLoop.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(4.560000000000002, 5.269999999999993), new SerializablePoint2D(3.4899999999999984, 3.1999999999999953), new SerializablePoint2D(4.999999999999996, 3.3499999999999908), new SerializablePoint2D(3.1999999999999966, 5.2099999999999875), new SerializablePoint2D(1.009999999999998, 2.1999999999999984)});
        this.tests.add(this.upsideDownLoop);
        this.fallThroughValley = new TestState.SplineTestState("Fall Through Valley", 0, 0.5, 0.0, true);
        this.fallThroughValley.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(1.0, 0.5), new SerializablePoint2D(2.0, 1.0), new SerializablePoint2D(3.0, 0.5), new SerializablePoint2D(4.0, 2.0), new SerializablePoint2D(5.0, 0.5)});
        this.tests.add(this.fallThroughValley);
        double d = 1.0;
        this.fallThroughValley2 = new TestState.FreeFallTestState("Fall Valley 2", 1.0, 0.0, 0.0, 0.0);
        this.fallThroughValley2.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(1.0 - d / 2.0, 0.0), new SerializablePoint2D(1.0, 3.0), new SerializablePoint2D(1.0 + d / 2.0, 0.0)});
        this.tests.add(this.fallThroughValley2);
        this.fallThroughPeak = new TestState.SplineTestState("Fall through Peak", 0, 0.92, 0.0, true);
        this.fallThroughPeak.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(0.0, 0.0), new SerializablePoint2D(1.0, 2.0), new SerializablePoint2D(2.0, 1.0), new SerializablePoint2D(3.0, 2.0), new SerializablePoint2D(4.0, 0.0)});
        this.tests.add(this.fallThroughPeak);
        this.fallOffSteep = new TestState.SplineTestState("Fall Steep", 0, 0.92, 0.0, true);
        this.fallOffSteep.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(1.0, 0.5), new SerializablePoint2D(2.0, 1.0), new SerializablePoint2D(2.7499999999999996, 4.519999999999998), new SerializablePoint2D(4.699999999999995, 4.219999999999991), new SerializablePoint2D(4.070000000000002, 0.12999999999999984)});
        this.tests.add(this.fallOffSteep);
        this.testApproachPeak = new TestState.SplineTestState("Approach Peak", 0, 0.91075, 0.0, true);
        this.testApproachPeak.addCubicSpline2D(new SerializablePoint2D[]{new SerializablePoint2D(0.0, 0.0), new SerializablePoint2D(1.0, 2.0), new SerializablePoint2D(2.0, 1.0), new SerializablePoint2D(3.0, 2.0), new SerializablePoint2D(4.0, 0.0)});
        this.tests.add(this.testApproachPeak);
    }

    public int getTestCount() {
        return this.tests.size();
    }

    public TestState getTest(int n) {
        return (TestState)this.tests.get(n);
    }
}

