/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.energyskatepark.model.physics.Particle;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;

public class ParticleImageNode
extends PNode {
    private final Particle particle;
    private final PImage imageNode;
    private final double w;
    private final double h;
    private final double scale;
    private boolean centered = false;

    public ParticleImageNode(final Particle particle) {
        this.particle = particle;
        this.imageNode = PImageFactory.create("energy-skate-park/images/skater3.png");
        this.w = this.imageNode.getFullBounds().getWidth();
        this.h = this.imageNode.getFullBounds().getHeight();
        this.scale = 0.0056;
        this.imageNode.scale(this.scale);
        this.addChild(this.imageNode);
        particle.addListener(new Particle.Listener(){

            public void particleChanged() {
                ParticleImageNode.this.update();
            }
        });
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                particle.setPosition(new SerializablePoint2D(pInputEvent.getPositionRelativeTo(ParticleImageNode.this)));
                particle.setUserControlled(true);
                particle.setVelocity(0.0, 0.0);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                particle.setUserControlled(false);
                particle.setFreeFall();
            }
        });
        this.update();
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean bl) {
        this.centered = bl;
        this.update();
    }

    public void update() {
        this.imageNode.setOffset(this.particle.getX(), this.particle.getY());
        this.imageNode.setRotation(this.particle.getAngle() + 1.5707963267948966);
        this.imageNode.translate(-this.w / 2.0, this.centered ? -this.h / 2.0 : -this.h);
    }
}

