/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.energyskatepark.model.physics.Particle;
import edu.colorado.phet.energyskatepark.model.physics.ParticleStage;
import java.util.ArrayList;

public class TestState {
    private final ArrayList controlPointSets = new ArrayList();
    private final String name;

    public TestState(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int numCubicSpline2Ds() {
        return this.controlPointSets.size();
    }

    public void addCubicSpline2D(SerializablePoint2D[] serializablePoint2DArray) {
        this.controlPointSets.add(serializablePoint2DArray);
    }

    public SerializablePoint2D[] getCubicSpline2D(int n) {
        return (SerializablePoint2D[])this.controlPointSets.get(n);
    }

    public void init(Particle particle, ParticleStage particleStage) {
    }

    public static class FreeFallTestState
    extends TestState {
        double x;
        double y;
        double vx;
        double vy;

        public FreeFallTestState(String string, double d, double d2, double d3, double d4) {
            super(string);
            this.x = d;
            this.y = d2;
            this.vx = d3;
            this.vy = d4;
        }

        public void init(Particle particle, ParticleStage particleStage) {
            super.init(particle, particleStage);
            particle.setFreeFall();
            particle.setPosition(this.x, this.y);
            particle.setVelocity(this.vx, this.vy);
        }
    }

    public static class SplineTestState
    extends TestState {
        private int splineIndex;
        double alpha;
        double velocity;
        boolean top;

        public SplineTestState(String string, int n, double d, double d2, boolean bl) {
            super(string);
            this.splineIndex = n;
            this.alpha = d;
            this.velocity = d2;
            this.top = bl;
        }

        public void init(Particle particle, ParticleStage particleStage) {
            super.init(particle, particleStage);
            particle.switchToTrack(particleStage.getCubicSpline2D(this.splineIndex), this.alpha, this.top);
            particle.getParticle1D().setVelocity(this.velocity);
        }
    }
}

