/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots;

import edu.colorado.phet.energyskatepark.plots.DefaultZoomControl;
import org.jfree.chart.axis.ValueAxis;

public class VerticalZoomControl
extends DefaultZoomControl {
    public VerticalZoomControl(ValueAxis valueAxis) {
        super(1, valueAxis);
    }

    protected void updateZoom() {
        double d;
        int n = this.getZoom();
        this.setZoomInEnabled(n > -13);
        this.setZoomOutEnabled(n < Integer.MAX_VALUE);
        double d2 = 7000 + n * 1000;
        if (n <= -7) {
            int n2 = Math.abs(n + 6);
            double d3 = Math.pow(2.0, n2);
            d2 = 1000.0 / d3;
        }
        d2 = Math.max(d2, 0.0);
        double d4 = d = n < 0 ? -500.0 : (double)(-500 - n * 500);
        if (n <= -7) {
            d = -d2 / 2.0;
        }
        this.getAxis().setRange(d, d + d2);
    }

    public void setZoom(int n) {
        super.setZoom(n);
        this.updateZoom();
    }
}

