/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.common.IconComponent;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.swing.ChooseCharacterDialog;
import edu.colorado.phet.energyskatepark.view.swing.ClearHeatButton;
import edu.colorado.phet.energyskatepark.view.swing.EditSkaterPanel;
import edu.colorado.phet.energyskatepark.view.swing.FrictionControl;
import edu.colorado.phet.energyskatepark.view.swing.LocationControlPanel;
import edu.colorado.phet.energyskatepark.view.swing.PathRecordContol;
import edu.colorado.phet.energyskatepark.view.swing.PieChartControlPanel;
import edu.umd.cs.piccolo.PNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class EnergySkateParkControlPanel
extends ControlPanel {
    private final AbstractEnergySkateParkModule module;
    private final PieChartControlPanel piePanel;
    private final PathRecordContol pathRecordContol;
    private final LocationControlPanel locationControlPanel;
    private final AdvancedPanel advancedFrictionPanel;
    private final EditSkaterPanel editSkaterPanel;

    public EnergySkateParkControlPanel(final AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        this.module = abstractEnergySkateParkModule;
        JButton jButton = new JButton(EnergySkateParkResources.getString("controls.reset"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergySkateParkControlPanel.this.doReset();
            }
        });
        this.addControl(jButton);
        JButton jButton2 = new JButton(EnergySkateParkResources.getString("controls.reset-character"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.returnOrResetSkater();
            }
        });
        this.addControl(jButton2);
        jButton2 = new JButton(EnergySkateParkResources.getString("controls.choose-character") + "...");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new ChooseCharacterDialog(abstractEnergySkateParkModule).setVisible(true);
            }
        });
        this.addControl(new IconComponent(jButton2, BufferedImageUtils.rescaleYMaintainAspectRatio(EnergySkateParkResources.getImage("skater3.png"), jButton2.getPreferredSize().height)));
        BufferedImage bufferedImage = EnergySkateParkResources.getImage("ruler-thumb.png");
        final JCheckBox jCheckBox = new JCheckBox(EnergySkateParkResources.getString("controls.measuring-tape"), abstractEnergySkateParkModule.isMeasuringTapeVisible());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.setMeasuringTapeVisible(jCheckBox.isSelected());
            }
        });
        this.getMeasuringTapeNode(abstractEnergySkateParkModule).addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jCheckBox.setSelected(EnergySkateParkControlPanel.this.getMeasuringTapeNode(abstractEnergySkateParkModule).getVisible());
            }
        });
        this.addControlFullWidth(new IconComponent(jCheckBox, bufferedImage));
        final JCheckBox jCheckBox2 = new JCheckBox(EnergySkateParkResources.getString("label.potential-energy-reference"));
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().setZeroPointVisible(jCheckBox2.isSelected());
            }
        });
        abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().addListener(new EnergySkateParkSimulationPanel.Adapter(){

            public void zeroPointEnergyVisibilityChanged() {
                jCheckBox2.setSelected(abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().isZeroPointVisible());
            }
        });
        BufferedImage bufferedImage2 = EnergySkateParkResources.getImage("peicon.png");
        this.addControlFullWidth(new IconComponent(jCheckBox2, bufferedImage2));
        this.addControlFullWidth(new PropertyCheckBox(EnergySkateParkResources.getString("controls.show-grid"), abstractEnergySkateParkModule.gridVisible));
        this.pathRecordContol = new PathRecordContol(abstractEnergySkateParkModule);
        this.addControlFullWidth(this.pathRecordContol);
        this.piePanel = new PieChartControlPanel(abstractEnergySkateParkModule, this);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillNone();
        verticalLayoutPanel.setAnchor(17);
        verticalLayoutPanel.setBorder(BorderFactory.createTitledBorder(EnergySkateParkResources.getString("plots.plot")));
        verticalLayoutPanel.add(this.piePanel);
        JButton jButton3 = new JButton(EnergySkateParkResources.getString("plots.energy-vs-time"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.showNewEnergyVsTimePlot();
            }
        });
        JButton jButton4 = new JButton(EnergySkateParkResources.getString("plots.energy-vs-position"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.setEnergyPositionPlotVisible(true);
            }
        });
        JButton jButton5 = new JButton(EnergySkateParkResources.getString("plots.bar-graph"));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.barChartVisible.set(true);
            }
        });
        verticalLayoutPanel.add(jButton5);
        verticalLayoutPanel.add(jButton4);
        verticalLayoutPanel.add(jButton3);
        this.addControlFullWidth(verticalLayoutPanel);
        this.locationControlPanel = new LocationControlPanel(abstractEnergySkateParkModule, abstractEnergySkateParkModule.getOptions().getPlanetButtonLayout(), abstractEnergySkateParkModule.getOptions().getPlanetButtonsCentered());
        this.addControl(this.locationControlPanel);
        this.addControl(new ClearHeatButton(abstractEnergySkateParkModule.getEnergySkateParkModel()));
        this.advancedFrictionPanel = new AdvancedPanel(EnergySkateParkResources.getString("controls.show-friction") + " >>", EnergySkateParkResources.getString("controls.hide-friction") + " <<");
        FrictionControl frictionControl = new FrictionControl(abstractEnergySkateParkModule);
        this.advancedFrictionPanel.addControl(frictionControl);
        frictionControl.getModelSlider().setBorder(null);
        this.addControl(this.advancedFrictionPanel);
        this.editSkaterPanel = new EditSkaterPanel(abstractEnergySkateParkModule);
        this.addControl(this.editSkaterPanel);
    }

    private PNode getMeasuringTapeNode(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        return abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().getMeasuringTapeNode();
    }

    private void doReset() {
        this.module.confirmAndReset();
    }

    public void reset() {
        this.pathRecordContol.reset();
        this.locationControlPanel.reset();
        this.advancedFrictionPanel.setAdvancedControlsVisible(false);
        this.editSkaterPanel.reset();
    }
}

